/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDFArrayBase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;

@Description(name="array_position", value="_FUNC_(array, element) - Returns the position of the first occurrence of element in array. Array indexing starts at 1. If the element value is NULL, a NULL is returned.", extended="Example:\n  > SELECT _FUNC_(array(1, 2, 3,4,2), 2) FROM src;\n  2")
public class GenericUDFArrayPosition
extends AbstractGenericUDFArrayBase {
    static final String FUNC_NAME = "ARRAY_POSITION";
    private static final int ELEMENT_IDX = 1;
    private transient ObjectInspector valueOI;

    public GenericUDFArrayPosition() {
        super(FUNC_NAME, 2, 2, ObjectInspector.Category.PRIMITIVE);
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        super.initialize(arguments);
        this.valueOI = arguments[1];
        this.checkValueAndListElementTypes(this.arrayElementOI, FUNC_NAME, this.valueOI, 1);
        return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object array = arguments[0].get();
        Object value = arguments[1].get();
        int arrayLength = this.arrayOI.getListLength(array);
        if (arrayLength < 0 || value == null) {
            return null;
        }
        for (int index = 0; index < arrayLength; ++index) {
            if (ObjectInspectorUtils.compare((Object)value, (ObjectInspector)this.valueOI, (Object)this.arrayOI.getListElement(array, index), (ObjectInspector)this.arrayElementOI) != 0) continue;
            return new IntWritable(index + 1);
        }
        return new IntWritable(0);
    }
}

