/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderFactory;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorContext;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MmMinorQueryCompactor
extends QueryCompactor {
    private static final Logger LOG = LoggerFactory.getLogger((String)MmMinorQueryCompactor.class.getName());

    MmMinorQueryCompactor() {
    }

    @Override
    public boolean run(CompactorContext context) throws IOException {
        HiveConf hiveConf = context.getConf();
        Table table = context.getTable();
        AcidDirectory dir = context.getAcidDirectory();
        LOG.debug("Going to delete directories for aborted transactions for MM table " + table.getDbName() + "." + table.getTableName());
        QueryCompactor.Util.removeFilesForMmTable(hiveConf, dir);
        StorageDescriptor storageDescriptor = context.getSd();
        ValidWriteIdList writeIds = context.getValidWriteIdList();
        HiveConf driverConf = this.setUpDriverSession(hiveConf);
        String tmpTableName = this.getTempTableName(table);
        String resultTmpTableName = tmpTableName + "_result";
        Path resultDeltaDir = QueryCompactor.Util.getCompactionResultDir(storageDescriptor, writeIds, driverConf, false, false, false, dir);
        List<String> createTableQueries = this.getCreateQueries(tmpTableName, table, storageDescriptor, dir, writeIds, resultDeltaDir);
        List<String> compactionQueries = this.getCompactionQueries(tmpTableName, resultTmpTableName, table);
        List<String> dropQueries = this.getDropQueries(tmpTableName);
        this.runCompactionQueries(driverConf, tmpTableName, context.getCompactionInfo(), Lists.newArrayList((Object[])new Path[]{resultDeltaDir}), createTableQueries, compactionQueries, dropQueries, table.getParameters());
        return true;
    }

    @Override
    protected HiveConf setUpDriverSession(HiveConf hiveConf) {
        HiveConf conf = super.setUpDriverSession(hiveConf);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_FETCH_COLUMN_STATS, false);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_ESTIMATE_STATS, false);
        return conf;
    }

    @Override
    protected void commitCompaction(String tmpTableName, HiveConf conf) throws IOException, HiveException {
        QueryCompactor.Util.cleanupEmptyTableDir(conf, tmpTableName);
    }

    private List<String> getCreateQueries(String tmpTableBase, Table t, StorageDescriptor sd, AcidDirectory dir, ValidWriteIdList writeIds, Path resultDeltaDir) {
        ArrayList queries = Lists.newArrayList((Object[])new String[]{this.getCreateQuery(tmpTableBase, t, sd, null, true), this.getCreateQuery(tmpTableBase + "_result", t, sd, resultDeltaDir.toString(), false)});
        String alterQuery = this.buildAlterTableQuery(tmpTableBase, dir, writeIds);
        if (!alterQuery.isEmpty()) {
            queries.add(alterQuery);
        }
        return queries;
    }

    private String getCreateQuery(String newTableName, Table t, StorageDescriptor sd, String location, boolean isPartitioned) {
        return new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MINOR, true).setOperation(CompactionQueryBuilder.Operation.CREATE).setResultTableName(newTableName).setStorageDescriptor(sd).setSourceTab(t).setLocation(location).setPartitioned(isPartitioned).build();
    }

    private String buildAlterTableQuery(String tableName, AcidDirectory dir, ValidWriteIdList validWriteIdList) {
        return new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MINOR, true).setOperation(CompactionQueryBuilder.Operation.ALTER).setResultTableName(tableName).setDir(dir).setValidWriteIdList(validWriteIdList).build();
    }

    private List<String> getCompactionQueries(String sourceTmpTableName, String resultTmpTableName, Table sourceTable) {
        return Lists.newArrayList((Object[])new String[]{new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MINOR, true).setOperation(CompactionQueryBuilder.Operation.INSERT).setResultTableName(resultTmpTableName).setSourceTabForInsert(sourceTmpTableName).setSourceTab(sourceTable).build()});
    }

    private List<String> getDropQueries(String tmpTableBase) {
        return Lists.newArrayList((Object[])new String[]{this.getDropQuery(tmpTableBase), this.getDropQuery(tmpTableBase + "_result")});
    }

    private String getDropQuery(String tableToDrop) {
        return new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MINOR, true).setOperation(CompactionQueryBuilder.Operation.DROP).setResultTableName(tableToDrop).build();
    }
}

