/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.txn.compactor.IMetaStoreClientFactory;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionHeartbeatService {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionHeartbeatService.class);
    private static volatile CompactionHeartbeatService instance;
    private final ObjectPool<IMetaStoreClient> clientPool;
    private volatile boolean shuttingDown = false;
    private final long initialDelay;
    private final long period;
    private final ConcurrentHashMap<Long, CompactionHeartbeater> tasks = new ConcurrentHashMap(30);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static CompactionHeartbeatService getInstance(HiveConf conf) {
        if (instance == null) {
            Class<CompactionHeartbeatService> clazz = CompactionHeartbeatService.class;
            // MONITORENTER : org.apache.hadoop.hive.ql.txn.compactor.CompactionHeartbeatService.class
            if (instance == null) {
                LOG.debug("Initializing compaction txn heartbeater service.");
                instance = new CompactionHeartbeatService(conf);
                ShutdownHookManager.addShutdownHook(() -> instance.shutdown(), (int)0);
            }
            // MONITOREXIT : clazz
        }
        if (!CompactionHeartbeatService.instance.shuttingDown) return instance;
        throw new IllegalStateException("CompactionHeartbeatService is already destroyed!");
    }

    public void startHeartbeat(long txnId, long lockId, String tableName) {
        if (this.shuttingDown) {
            throw new IllegalStateException("Service is shutting down, starting new heartbeats is not possible!");
        }
        if (this.tasks.containsKey(txnId)) {
            throw new IllegalStateException("Heartbeat was already started for TXN " + txnId);
        }
        LOG.info("Submitting heartbeat task for TXN {}", (Object)txnId);
        CompactionHeartbeater heartbeater = new CompactionHeartbeater(txnId, lockId, tableName);
        heartbeater.start();
        this.tasks.put(txnId, heartbeater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHeartbeat(long txnId) throws InterruptedException {
        LOG.info("Stopping heartbeat task for TXN {}", (Object)txnId);
        CompactionHeartbeater heartbeater = this.tasks.get(txnId);
        if (heartbeater == null) {
            throw new IllegalStateException("No registered heartbeat found for TXN " + txnId);
        }
        try {
            heartbeater.stop();
        }
        finally {
            this.tasks.remove(txnId);
        }
    }

    void shutdown() {
        this.shuttingDown = true;
        LOG.info("Shutting down compaction txn heartbeater service.");
        for (CompactionHeartbeater heartbeater : this.tasks.values()) {
            try {
                heartbeater.stop();
            }
            catch (InterruptedException e) {
                LOG.warn("Shutdownhook thread was interrupted during shutting down the CompactionHeartbeatService.");
            }
        }
        this.tasks.clear();
        this.clientPool.close();
        LOG.info("Compaction txn heartbeater service is successfully stopped.");
    }

    private CompactionHeartbeatService(HiveConf conf) {
        int numberOfWorkers = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_WORKER_THREADS);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMinIdle(1);
        config.setMaxIdle(2);
        config.setMaxTotal(numberOfWorkers);
        config.setMaxWaitMillis(2000L);
        this.clientPool = new GenericObjectPool((PooledObjectFactory)new IMetaStoreClientFactory(conf), config);
        long txnTimeout = MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        this.initialDelay = txnTimeout / 4L;
        this.period = txnTimeout / 2L;
    }

    private final class CompactionHeartbeater {
        private final Logger LOG = LoggerFactory.getLogger(CompactionHeartbeater.class);
        private final long txnId;
        private final long lockId;
        private final String tableName;
        private final ScheduledThreadPoolExecutor heartbeatExecutor = new ScheduledThreadPoolExecutor(1);

        private CompactionHeartbeater(long txnId, long lockId, String tableName) {
            this.heartbeatExecutor.setThreadFactory(new ThreadFactoryBuilder().setPriority(1).setDaemon(true).setNameFormat("CompactionTxnHeartbeater-" + txnId).build());
            this.tableName = Objects.requireNonNull(tableName);
            this.txnId = txnId;
            this.lockId = lockId;
        }

        void start() {
            this.heartbeatExecutor.scheduleAtFixedRate(() -> {
                IMetaStoreClient msc = null;
                try {
                    this.LOG.debug("Heartbeating compaction transaction id {} for table: {}", (Object)this.txnId, (Object)this.tableName);
                    msc = (IMetaStoreClient)CompactionHeartbeatService.this.clientPool.borrowObject();
                    msc.heartbeat(this.txnId, this.lockId);
                }
                catch (NoSuchElementException e) {
                    this.LOG.error("Compaction transaction heartbeater pool exhausted, unable to heartbeat", (Throwable)e);
                    return;
                }
                catch (TException e) {
                    this.LOG.error("Error while heartbeating compaction transaction id {} for table: {}", new Object[]{this.txnId, this.tableName, e});
                }
                catch (Exception e) {
                    this.LOG.error("Error while heartbeating compaction transaction id {} for table: {}", new Object[]{this.txnId, this.tableName, e});
                    if (msc != null) {
                        try {
                            CompactionHeartbeatService.this.clientPool.invalidateObject((Object)msc);
                        }
                        catch (Exception ex) {
                            this.LOG.error("Error while invalidating a broken MetaStoreClient instance", (Throwable)e);
                        }
                    }
                    return;
                }
                try {
                    if (msc != null) {
                        CompactionHeartbeatService.this.clientPool.returnObject((Object)msc);
                    }
                }
                catch (Exception e) {
                    this.LOG.error("Error while returning back to the pool a MetaStoreClient instance", (Throwable)e);
                }
            }, CompactionHeartbeatService.this.initialDelay, CompactionHeartbeatService.this.period, TimeUnit.MILLISECONDS);
        }

        public void stop() throws InterruptedException {
            this.LOG.info("Shutting down compaction txn heartbeater instance.");
            this.heartbeatExecutor.shutdownNow();
            if (!this.heartbeatExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.LOG.warn("Heartbeating for transaction {} did not stop in 5 seconds, do not wait any longer.", (Object)this.txnId);
                return;
            }
            this.LOG.info("Compaction txn heartbeater instance is successfully stopped.");
        }
    }
}

