/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordReader;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.BasicStatsNoJobWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.IStatsProcessor;
import org.apache.hadoop.hive.ql.stats.Partish;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicStatsNoJobTask
implements IStatsProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(BasicStatsNoJobTask.class);
    private HiveConf conf;
    private BasicStatsNoJobWork work;
    private SessionState.LogHelper console;

    public BasicStatsNoJobTask(HiveConf conf, BasicStatsNoJobWork work) {
        this.conf = conf;
        this.work = work;
        this.console = new SessionState.LogHelper(LOG);
    }

    public static boolean canUseBasicStats(Table table, Class<? extends InputFormat> inputFormat) {
        return BasicStatsNoJobTask.canUseFooterScan(table, inputFormat) || BasicStatsNoJobTask.useBasicStatsFromStorageHandler(table);
    }

    public static boolean canUseFooterScan(Table table, Class<? extends InputFormat> inputFormat) {
        return OrcInputFormat.class.isAssignableFrom(inputFormat) && !AcidUtils.isFullAcidTable(table) || MapredParquetInputFormat.class.isAssignableFrom(inputFormat);
    }

    private static boolean useBasicStatsFromStorageHandler(Table table) {
        return table.isNonNative() && table.getStorageHandler().canProvideBasicStatistics();
    }

    @Override
    public void initialize(CompilationOpContext opContext) {
    }

    @Override
    public int process(Hive db, Table tbl) throws Exception {
        LOG.info("Executing stats (no job) task");
        ExecutorService threadPool = StatsTask.newThreadPool(this.conf);
        return this.aggregateStats(threadPool, db);
    }

    public StageType getType() {
        return StageType.STATS;
    }

    public String getName() {
        return "STATS-NO-JOB";
    }

    private Collection<Partition> getPartitions(Table table) {
        Collection<Partition> partitions = null;
        if (this.work.getPartitions() == null || this.work.getPartitions().isEmpty()) {
            if (table.isPartitioned() && !table.hasNonNativePartitionSupport()) {
                partitions = table.getTableSpec().partitions;
            }
        } else {
            partitions = this.work.getPartitions();
        }
        return partitions;
    }

    private List<Partish> getPartishes(Table table) {
        Collection<Partition> partitions = this.getPartitions(table);
        LinkedList partishes = Lists.newLinkedList();
        if (partitions == null) {
            partishes.add(Partish.buildFor(table));
        } else {
            for (Partition part : partitions) {
                partishes.add(Partish.buildFor(table, part));
            }
        }
        return partishes;
    }

    private int aggregateStats(ExecutorService threadPool, Hive db) {
        int ret;
        block6: {
            ret = 0;
            try {
                JobConf jc = new JobConf((Configuration)this.conf);
                BaseSemanticAnalyzer.TableSpec tableSpecs = this.work.getTableSpecs();
                if (tableSpecs == null) {
                    throw new RuntimeException("this is unexpected...needs some investigation");
                }
                Table table = tableSpecs.tableHandle;
                List<Partish> partishes = this.getPartishes(table);
                ArrayList<StatCollector> scs = new ArrayList<StatCollector>();
                for (Partish partish : partishes) {
                    if (BasicStatsNoJobTask.useBasicStatsFromStorageHandler(table)) {
                        scs.add(new HiveStorageHandlerStatCollector(partish));
                        continue;
                    }
                    scs.add(new FooterStatCollector(jc, partish));
                }
                for (StatCollector sc : scs) {
                    sc.init(this.conf, this.console);
                    threadPool.execute(sc);
                }
                LOG.debug("Stats collection waiting for threadpool to shutdown..");
                this.shutdownAndAwaitTermination(threadPool);
                LOG.debug("Stats collection threadpool shutdown successful.");
                ret = this.updatePartitions(db, scs, table);
            }
            catch (Exception e) {
                this.console.printError("Failed to collect footer statistics.", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
                if (!this.work.isStatsReliable()) break block6;
                ret = -1;
            }
        }
        return ret;
    }

    private int updatePartitions(Hive db, List<StatCollector> scs, Table table) throws InvalidOperationException, HiveException {
        String tableFullName = table.getFullyQualifiedName();
        if (scs.isEmpty()) {
            return 0;
        }
        if (this.work.isStatsReliable()) {
            for (StatCollector statCollector : scs) {
                if (statCollector.isValid()) continue;
                LOG.debug("Stats requested to be reliable. Empty stats found: {}", (Object)statCollector.partish.getSimpleName());
                return -1;
            }
        }
        ArrayList validColectors = Lists.newArrayList();
        for (StatCollector statsCollection : scs) {
            if (!statsCollection.isValid()) continue;
            validColectors.add(statsCollection);
        }
        EnvironmentContext environmentContext = new EnvironmentContext();
        environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
        ImmutableListMultimap collectorsByTable = Multimaps.index((Iterable)validColectors, (Function)FooterStatCollector.SIMPLE_NAME_FUNCTION);
        LOG.debug("Collectors.size(): {}", (Object)collectorsByTable.keySet());
        if (collectorsByTable.keySet().size() < 1) {
            LOG.warn("Collectors are empty! ; {}", (Object)tableFullName);
        }
        assert (collectorsByTable.keySet().size() <= 1);
        LOG.debug("Updating stats for: {}", (Object)tableFullName);
        for (String partName : collectorsByTable.keySet()) {
            ImmutableList values = collectorsByTable.get((Object)partName);
            if (values == null) {
                throw new RuntimeException("very intresting");
            }
            if (((StatCollector)values.get((int)0)).result instanceof Table) {
                db.alterTable(tableFullName, (Table)((StatCollector)values.get((int)0)).result, environmentContext, true);
                LOG.debug("Updated stats for {}.", (Object)tableFullName);
                continue;
            }
            if (((StatCollector)values.get((int)0)).result instanceof Partition) {
                List results = Lists.transform((List)values, StatCollector.EXTRACT_RESULT_FUNCTION);
                db.alterPartitions(tableFullName, results, environmentContext, true);
                LOG.debug("Bulk updated {} partitions of {}.", (Object)results.size(), (Object)tableFullName);
                continue;
            }
            throw new RuntimeException("inconsistent");
        }
        LOG.debug("Updated stats for: {}", (Object)tableFullName);
        return 0;
    }

    private void shutdownAndAwaitTermination(ExecutorService threadPool) {
        threadPool.shutdown();
        try {
            while (!threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOG.debug("Waiting for all stats tasks to finish...");
            }
            threadPool.shutdownNow();
            if (!threadPool.awaitTermination(100L, TimeUnit.SECONDS)) {
                LOG.debug("Stats collection thread pool did not terminate");
            }
        }
        catch (InterruptedException ie) {
            threadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void setDpPartSpecs(Collection<Partition> dpPartSpecs) {
    }

    static class HiveStorageHandlerStatCollector
    extends StatCollector {
        public HiveStorageHandlerStatCollector(Partish partish) {
            this.partish = partish;
        }

        @Override
        public void run() {
            try {
                Map<String, String> parameters;
                Table table = this.partish.getTable();
                Map<String, String> basicStatistics = table.getStorageHandler().getBasicStatistics(this.partish);
                if (this.partish.getPartition() != null) {
                    parameters = this.partish.getPartParameters();
                    this.result = new Partition(table, this.partish.getPartition().getTPartition());
                } else {
                    parameters = table.getParameters();
                    this.result = new Table(table.getTTable());
                }
                parameters.putAll(basicStatistics);
                StatsSetupConst.setBasicStatsState(parameters, (String)"true");
                String msg = this.partish.getSimpleName() + " stats: [" + this.toString(parameters) + "]";
                LOG.debug(msg);
                this.console.printInfo(msg);
            }
            catch (Exception e) {
                this.console.printInfo("[Warning] could not update stats for " + this.partish.getSimpleName() + ".", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    static class FooterStatCollector
    extends StatCollector {
        private JobConf jc;
        private Path dir;
        private FileSystem fs;
        private SessionState.LogHelper console;

        public FooterStatCollector(JobConf jc, Partish partish) {
            this.jc = jc;
            this.partish = partish;
        }

        @Override
        public void init(HiveConf conf, SessionState.LogHelper console) throws IOException {
            this.console = console;
            this.dir = new Path(this.partish.getPartSd().getLocation());
            this.fs = this.dir.getFileSystem((Configuration)conf);
        }

        @Override
        public void run() {
            Map<String, String> parameters = this.partish.getPartParameters();
            try {
                long numRows = 0L;
                long rawDataSize = 0L;
                long fileSize = 0L;
                long numFiles = 0L;
                long numErasureCodedFiles = 0L;
                Utilities.FILE_OP_LOGGER.debug("Aggregating stats for {}", (Object)this.dir);
                List<FileStatus> fileList = null;
                fileList = this.partish.getTable() != null && AcidUtils.isTransactionalTable(this.partish.getTable()) ? AcidUtils.getAcidFilesForStats(this.partish.getTable(), this.dir, (Configuration)this.jc, this.fs) : HiveStatsUtils.getFileStatusRecurse((Path)this.dir, (int)-1, (FileSystem)this.fs);
                ThreadPoolExecutor tpE = null;
                ArrayList<Future<FileStats>> futures = null;
                int numThreadsFactor = HiveConf.getIntVar((Configuration)this.jc, (HiveConf.ConfVars)HiveConf.ConfVars.BASIC_STATS_TASKS_MAX_THREADS_FACTOR);
                if (fileList.size() > 1 && numThreadsFactor > 0) {
                    int numThreads = Math.min(fileList.size(), numThreadsFactor * Runtime.getRuntime().availableProcessors());
                    ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Basic-Stats-Thread-%d").build();
                    tpE = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
                    tpE.allowsCoreThreadTimeOut();
                    futures = new ArrayList<Future<FileStats>>();
                    LOG.info("Processing Stats for {} file using {} threads", (Object)fileList.size(), (Object)numThreads);
                }
                for (FileStatus fileStatus : fileList) {
                    Utilities.FILE_OP_LOGGER.debug("Computing stats for {}", (Object)fileStatus);
                    if (fileStatus.isDirectory()) continue;
                    InputFormat inputFormat = (InputFormat)ReflectionUtil.newInstance(this.partish.getInputFormatClass(), (Configuration)this.jc);
                    FileSplit dummySplit = new FileSplit(fileStatus.getPath(), 0L, -1L, new String[]{this.partish.getLocation()});
                    if (fileStatus.getLen() == 0L) {
                        ++numFiles;
                        continue;
                    }
                    FileStatProcessor fsp = new FileStatProcessor(fileStatus, inputFormat, (InputSplit)dummySplit, this.jc);
                    if (tpE != null) {
                        futures.add(tpE.submit(fsp));
                        continue;
                    }
                    FileStats fileStat = fsp.call();
                    rawDataSize += fileStat.getRawDataSize();
                    numRows += fileStat.getNumRows();
                    fileSize += fileStat.getFileSize();
                    ++numFiles;
                    numErasureCodedFiles += fileStat.getNumErasureCodedFiles();
                }
                if (tpE != null) {
                    try {
                        for (Future future : futures) {
                            FileStats fileStat = (FileStats)future.get();
                            rawDataSize += fileStat.getRawDataSize();
                            numRows += fileStat.getNumRows();
                            fileSize += fileStat.getFileSize();
                            ++numFiles;
                            numErasureCodedFiles += fileStat.getNumErasureCodedFiles();
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Encountered exception while collecting stats for file lists as {}", fileList, (Object)e);
                        futures.forEach(x -> x.cancel(true));
                        throw e;
                    }
                    finally {
                        tpE.shutdown();
                    }
                }
                StatsSetupConst.setBasicStatsState(parameters, (String)"true");
                parameters.put("numRows", String.valueOf(numRows));
                parameters.put("rawDataSize", String.valueOf(rawDataSize));
                parameters.put("totalSize", String.valueOf(fileSize));
                parameters.put("numFiles", String.valueOf(numFiles));
                parameters.put("numFilesErasureCoded", String.valueOf(numErasureCodedFiles));
                this.result = this.partish.getPartition() != null ? new Partition(this.partish.getTable(), this.partish.getPartition().getTPartition()) : new Table(this.partish.getTable().getTTable());
                String msg = this.partish.getSimpleName() + " stats: [" + this.toString(parameters) + "]";
                LOG.debug(msg);
                this.console.printInfo(msg);
            }
            catch (Exception e) {
                this.console.printInfo("[Warning] could not update stats for " + this.partish.getSimpleName() + ".", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    static abstract class StatCollector
    implements Runnable {
        protected Partish partish;
        protected Object result;
        protected SessionState.LogHelper console;
        public static Function<StatCollector, String> SIMPLE_NAME_FUNCTION = sc -> String.format("%s#%s", sc.partish.getTable().getCompleteName(), sc.partish.getPartishType());
        public static Function<StatCollector, Partition> EXTRACT_RESULT_FUNCTION = sc -> (Partition)sc.result;

        StatCollector() {
        }

        protected void init(HiveConf conf, SessionState.LogHelper console) throws IOException {
            this.console = console;
        }

        protected final boolean isValid() {
            return this.result != null;
        }

        protected final String toString(Map<String, String> parameters) {
            return StatsSetupConst.SUPPORTED_STATS.stream().map(st -> st + "=" + (String)parameters.get(st)).collect(Collectors.joining(", "));
        }
    }

    private static class FileStats {
        private long numRows = 0L;
        private long rawDataSize = 0L;
        private long fileSize = 0L;
        private long numErasureCodedFiles = 0L;

        public FileStats(long rawDataSize, long numRows, long fileSize, boolean isErasureCoded) {
            this.rawDataSize = rawDataSize;
            this.numRows = numRows;
            this.fileSize = fileSize;
            this.numErasureCodedFiles = isErasureCoded ? 1L : 0L;
        }

        public long getNumRows() {
            return this.numRows;
        }

        public long getRawDataSize() {
            return this.rawDataSize;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public long getNumErasureCodedFiles() {
            return this.numErasureCodedFiles;
        }
    }

    private static class FileStatProcessor
    implements Callable<FileStats> {
        private final InputSplit dummySplit;
        private final InputFormat<?, ?> inputFormat;
        private final JobConf jc;
        private final FileStatus file;

        FileStatProcessor(FileStatus file, InputFormat<?, ?> inputFormat, InputSplit dummySplit, JobConf jc) {
            this.file = file;
            this.dummySplit = dummySplit;
            this.inputFormat = inputFormat;
            this.jc = jc;
        }

        @Override
        public FileStats call() throws Exception {
            try (RecordReader recordReader = this.inputFormat.getRecordReader(this.dummySplit, this.jc, Reporter.NULL);){
                if (recordReader instanceof StatsProvidingRecordReader) {
                    FileStats fileStats;
                    StatsProvidingRecordReader statsRR = (StatsProvidingRecordReader)recordReader;
                    FileStats fileStats2 = fileStats = new FileStats(statsRR.getStats().getRawDataSize(), statsRR.getStats().getRowCount(), this.file.getLen(), this.file.isErasureCoded());
                    return fileStats2;
                }
                throw new HiveException(String.format("Unexpected file found during reading footers for: %s ", this.file));
            }
        }
    }
}

