/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.reexec;

import com.google.common.base.Throwables;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.reexec.IReExecutionPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReExecuteOnWriteConflictPlugin
implements IReExecutionPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ReExecuteOnWriteConflictPlugin.class);
    private static boolean retryPossible;
    private static final String validationException = "org.apache.iceberg.exceptions.ValidationException";

    @Override
    public void initialize(Driver driver) {
        driver.getHookRunner().addOnFailureHook(new LocalHook());
    }

    @Override
    public boolean shouldReExecute(int executionNum) {
        return retryPossible;
    }

    @Override
    public boolean shouldReExecuteAfterCompile(int executionNum, PlanMapper oldPlanMapper, PlanMapper newPlanMapper) {
        return retryPossible;
    }

    private static final class LocalHook
    implements ExecuteWithHookContext {
        private LocalHook() {
        }

        @Override
        public void run(HookContext hookContext) throws Exception {
            Throwable exception;
            if (hookContext.getHookType() == HookContext.HookType.ON_FAILURE_HOOK && (exception = hookContext.getException()) != null && exception.getMessage() != null) {
                Throwable cause = Throwables.getRootCause((Throwable)exception);
                if (cause.getClass().getName().equals(ReExecuteOnWriteConflictPlugin.validationException)) {
                    retryPossible = true;
                    LOG.info("Retrying query due to write conflict.");
                }
                LOG.info("Got exception message: {} retryPossible: {}", (Object)exception.getMessage(), (Object)retryPossible);
            }
        }
    }
}

