/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite;

import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.rewrite.Rewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.UpdateStatement;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.COWWithClauseBuilder;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.MultiInsertSqlGenerator;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.SetClausePatcher;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.SqlGeneratorFactory;

public class CopyOnWriteUpdateRewriter
implements Rewriter<UpdateStatement> {
    private final HiveConf conf;
    private final SqlGeneratorFactory sqlGeneratorFactory;
    private final COWWithClauseBuilder cowWithClauseBuilder;
    private final SetClausePatcher setClausePatcher;

    public CopyOnWriteUpdateRewriter(HiveConf conf, SqlGeneratorFactory sqlGeneratorFactory) {
        this.conf = conf;
        this.sqlGeneratorFactory = sqlGeneratorFactory;
        this.cowWithClauseBuilder = new COWWithClauseBuilder();
        this.setClausePatcher = new SetClausePatcher();
    }

    @Override
    public ParseUtils.ReparseResult rewrite(Context context, UpdateStatement updateBlock) throws SemanticException {
        boolean shouldOverwrite;
        String filePathCol = HiveUtils.unparseIdentifier(VirtualColumn.FILE_PATH.getName(), (Configuration)this.conf);
        MultiInsertSqlGenerator sqlGenerator = this.sqlGeneratorFactory.createSqlGenerator();
        String whereClause = null;
        int columnOffset = 0;
        boolean bl = shouldOverwrite = updateBlock.getWhereTree() == null;
        if (shouldOverwrite) {
            sqlGenerator.append("insert overwrite table ");
        } else {
            Tree wherePredicateNode = updateBlock.getWhereTree().getChild(0);
            whereClause = context.getTokenRewriteStream().toString(wherePredicateNode.getTokenStartIndex(), wherePredicateNode.getTokenStopIndex());
            this.cowWithClauseBuilder.appendWith(sqlGenerator, filePathCol, whereClause);
            sqlGenerator.append("insert into table ");
            columnOffset = sqlGenerator.getDeleteValues(Context.Operation.UPDATE).size();
        }
        sqlGenerator.appendTargetTableName();
        sqlGenerator.appendPartitionColsOfTarget();
        sqlGenerator.append(" select ");
        if (!shouldOverwrite) {
            sqlGenerator.appendAcidSelectColumns(Context.Operation.UPDATE);
            sqlGenerator.removeLastChar();
        }
        HashMap<Integer, ASTNode> setColExprs = new HashMap<Integer, ASTNode>(updateBlock.getSetCols().size());
        List<FieldSchema> nonPartCols = updateBlock.getTargetTable().getCols();
        for (int i = 0; i < nonPartCols.size(); ++i) {
            if (columnOffset > 0 || i > 0) {
                sqlGenerator.append(',');
            }
            String name = nonPartCols.get(i).getName();
            ASTNode setCol = updateBlock.getSetCols().get(name);
            String identifier = HiveUtils.unparseIdentifier(name, (Configuration)this.conf);
            sqlGenerator.append(identifier);
            sqlGenerator.append(" AS ").append(identifier);
            if (setCol == null) continue;
            setColExprs.put(columnOffset + i, setCol);
        }
        sqlGenerator.append(" from ");
        sqlGenerator.appendTargetTableName();
        if (whereClause != null) {
            sqlGenerator.append("\nwhere ");
            sqlGenerator.append(whereClause);
            sqlGenerator.append("\nunion all");
            sqlGenerator.append("\nselect ");
            sqlGenerator.appendAcidSelectColumns(Context.Operation.DELETE);
            sqlGenerator.removeLastChar();
            sqlGenerator.append(" from ");
            sqlGenerator.appendTargetTableName();
            sqlGenerator.append("\nwhere ");
            sqlGenerator.append("( NOT(%s) OR (%s) IS NULL )".replace("%s", whereClause));
            sqlGenerator.append("\n").indent();
            sqlGenerator.append("AND ").append(filePathCol);
            sqlGenerator.append(" IN ( select ").append(filePathCol).append(" from t )");
            sqlGenerator.append("\nunion all");
            sqlGenerator.append("\nselect * from t");
        }
        ParseUtils.ReparseResult rr = ParseUtils.parseRewrittenQuery(context, sqlGenerator.toString());
        Context rewrittenCtx = rr.rewrittenCtx;
        ASTNode rewrittenTree = rr.rewrittenTree;
        ASTNode rewrittenInsert = (ASTNode)(!shouldOverwrite ? new CalcitePlanner.ASTSearcher().simpleBreadthFirstSearch(rewrittenTree, 1032, 1236, 1295).getChild(0).getChild(0) : rewrittenTree).getChild(1);
        if (shouldOverwrite) {
            rewrittenCtx.addDestNamePrefix(1, Context.DestClausePrefix.INSERT);
        } else {
            rewrittenCtx.setOperation(Context.Operation.UPDATE);
            rewrittenCtx.addDestNamePrefix(1, Context.DestClausePrefix.UPDATE);
        }
        this.setClausePatcher.patchProjectionForUpdate(rewrittenInsert, setColExprs);
        rewrittenCtx.setEnableUnparse(false);
        return rr;
    }
}

