/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReplState {
    private static final Logger REPL_LOG = LoggerFactory.getLogger((String)"ReplState");
    private static final ObjectMapper mapper = new ObjectMapper();

    public void log(LogTag tag) {
        try {
            REPL_LOG.info("REPL::{}: {}", (Object)tag.name(), (Object)mapper.writeValueAsString((Object)this));
        }
        catch (Exception exception) {
            REPL_LOG.error("Could not serialize REPL log: {}", (Object)exception.getMessage());
        }
    }

    static {
        mapper.configure(MapperFeature.AUTO_DETECT_GETTERS, false);
        mapper.configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false);
        mapper.configure(MapperFeature.AUTO_DETECT_FIELDS, false);
    }

    public static enum LogTag {
        START,
        TABLE_DUMP,
        FUNCTION_DUMP,
        EVENT_DUMP,
        ATLAS_DUMP_START,
        ATLAS_DUMP_END,
        RANGER_DUMP_START,
        RANGER_DUMP_END,
        TABLE_LOAD,
        FUNCTION_LOAD,
        EVENT_LOAD,
        ATLAS_LOAD_START,
        ATLAS_LOAD_END,
        RANGER_LOAD_START,
        RANGER_LOAD_END,
        END,
        DATA_COPY_END;

    }
}

