/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.Pair;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.PTFUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTBuilder;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CBOPlan;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.HiveLexer;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseResult;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParseUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ParseUtils.class);

    public static ASTNode parse(String command, Context ctx) throws ParseException {
        return ParseUtils.parse(command, ctx, null);
    }

    public static ASTNode parse(String command, Context ctx, String viewFullyQualifiedName) throws ParseException {
        ParseDriver pd = new ParseDriver();
        Configuration configuration = ctx != null ? ctx.getConf() : null;
        ParseResult parseResult = pd.parse(command, configuration);
        if (ctx != null) {
            if (viewFullyQualifiedName == null) {
                ctx.setTokenRewriteStream(parseResult.getTokenRewriteStream());
            } else {
                ctx.addViewTokenRewriteStream(viewFullyQualifiedName, parseResult.getTokenRewriteStream());
            }
            ctx.setParsedTables(parseResult.getTables());
        }
        ASTNode tree = parseResult.getTree();
        tree = ParseUtils.findRootNonNullToken(tree);
        ParseUtils.handleSetColRefs(tree, ctx);
        return tree;
    }

    public static boolean isJoinToken(ASTNode node) {
        switch (node.getToken().getType()) {
            case 1034: 
            case 1073: 
            case 1078: 
            case 1183: {
                return true;
            }
        }
        return false;
    }

    private static ASTNode findRootNonNullToken(ASTNode tree) {
        while (tree.getToken() == null && tree.getChildCount() > 0) {
            tree = (ASTNode)tree.getChild(0);
        }
        return tree;
    }

    private ParseUtils() {
    }

    public static List<String> validateColumnNameUniqueness(List<FieldSchema> fieldSchemas) throws SemanticException {
        Iterator<FieldSchema> iterCols = fieldSchemas.iterator();
        ArrayList<String> colNames = new ArrayList<String>();
        while (iterCols.hasNext()) {
            String colName = iterCols.next().getName();
            for (String oldColName : colNames) {
                if (!colName.equalsIgnoreCase(oldColName)) continue;
                throw new SemanticException(ErrorMsg.DUPLICATE_COLUMN_NAMES.getMsg(oldColName));
            }
            colNames.add(colName);
        }
        return colNames;
    }

    public static VarcharTypeInfo getVarcharTypeInfo(ASTNode node) throws SemanticException {
        if (node.getChildCount() != 1) {
            throw new SemanticException("Bad params for type varchar");
        }
        String lengthStr = node.getChild(0).getText();
        return TypeInfoFactory.getVarcharTypeInfo((int)Integer.parseInt(lengthStr));
    }

    public static CharTypeInfo getCharTypeInfo(ASTNode node) throws SemanticException {
        if (node.getChildCount() != 1) {
            throw new SemanticException("Bad params for type char");
        }
        String lengthStr = node.getChild(0).getText();
        return TypeInfoFactory.getCharTypeInfo((int)Integer.parseInt(lengthStr));
    }

    static int getIndex(String[] list, String elem) {
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null || !list[i].toLowerCase().equals(elem)) continue;
            return i;
        }
        return -1;
    }

    static int checkJoinFilterRefersOneAlias(String[] tabAliases, ASTNode filterCondn) {
        int i;
        switch (filterCondn.getType()) {
            case 1270: {
                String tableOrCol = BaseSemanticAnalyzer.unescapeIdentifier(filterCondn.getChild(0).getText().toLowerCase());
                return ParseUtils.getIndex(tabAliases, tableOrCol);
            }
            case 24: 
            case 25: 
            case 147: 
            case 371: 
            case 424: 
            case 425: 
            case 436: 
            case 937: 
            case 977: 
            case 1101: 
            case 1234: {
                return -1;
            }
        }
        int idx = -1;
        int n = i = filterCondn.getType() == 1035 ? 1 : 0;
        while (i < filterCondn.getChildCount()) {
            int cIdx = ParseUtils.checkJoinFilterRefersOneAlias(tabAliases, (ASTNode)filterCondn.getChild(i));
            if (cIdx != idx) {
                if (idx != -1 && cIdx != -1) {
                    return -1;
                }
                idx = idx == -1 ? cIdx : idx;
            }
            ++i;
        }
        return idx;
    }

    public static DecimalTypeInfo getDecimalTypeTypeInfo(ASTNode node) throws SemanticException {
        if (node.getChildCount() > 2) {
            throw new SemanticException("Bad params for type decimal");
        }
        int precision = 10;
        int scale = 0;
        if (node.getChildCount() >= 1) {
            String precStr = node.getChild(0).getText();
            precision = Integer.parseInt(precStr);
        }
        if (node.getChildCount() == 2) {
            String scaleStr = node.getChild(1).getText();
            scale = Integer.parseInt(scaleStr);
        }
        return TypeInfoFactory.getDecimalTypeInfo((int)precision, (int)scale);
    }

    public static String ensureClassExists(String className) throws SemanticException {
        if (className == null) {
            return null;
        }
        try {
            Class.forName(className, true, Utilities.getSessionSpecifiedClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException("Cannot find class '" + className + "'", (Throwable)e);
        }
        return className;
    }

    public static Pair<Boolean, String> containsTokenOfType(ASTNode root, Integer ... tokens) {
        final HashSet<Integer> tokensToMatch = new HashSet<Integer>(Arrays.asList(tokens));
        final String[] matched = new String[]{null};
        boolean check = ParseUtils.containsTokenOfType(root, new PTFUtils.Predicate<ASTNode>(){

            @Override
            public boolean apply(ASTNode node) {
                if (tokensToMatch.contains(node.getType())) {
                    matched[0] = node.getText();
                    return true;
                }
                return false;
            }
        });
        return Pair.of((Object)check, (Object)matched[0]);
    }

    public static boolean containsTokenOfType(ASTNode root, PTFUtils.Predicate<ASTNode> predicate) {
        ArrayDeque<ASTNode> queue = new ArrayDeque<ASTNode>();
        queue.add(root);
        while (!queue.isEmpty()) {
            ASTNode current = (ASTNode)queue.remove();
            if (predicate.apply(current)) {
                return true;
            }
            if (current.getChildCount() <= 0) continue;
            for (Node child : current.getChildren()) {
                queue.add((ASTNode)child);
            }
        }
        return false;
    }

    private static void handleSetColRefs(ASTNode tree, Context ctx) {
        CalcitePlanner.ASTSearcher astSearcher = new CalcitePlanner.ASTSearcher();
        while (true) {
            astSearcher.reset();
            ASTNode setCols = astSearcher.depthFirstSearch(tree, 1197);
            if (setCols == null) break;
            ParseUtils.processSetColsNode(setCols, astSearcher, ctx);
        }
    }

    private static void processSetColsNode(ASTNode setCols, CalcitePlanner.ASTSearcher searcher, Context ctx) {
        ASTNode select;
        Tree child;
        Tree fromWhat;
        searcher.reset();
        ASTNode rootNode = setCols;
        while (rootNode != null && rootNode.getType() != 1055) {
            rootNode = rootNode.parent;
        }
        if (rootNode == null || rootNode.parent == null) {
            LOG.debug("Replacing SETCOLREF with ALLCOLREF because we couldn't find the root INSERT");
            setCols.token.setType(837);
            return;
        }
        rootNode = rootNode.parent;
        Tree fromNode = null;
        for (int j = 0; j < rootNode.getChildCount(); ++j) {
            Tree child2 = rootNode.getChild(j);
            if (child2.getType() != 1032) continue;
            fromNode = child2;
            break;
        }
        if (!(fromNode instanceof ASTNode)) {
            LOG.debug("Replacing SETCOLREF with ALLCOLREF because we couldn't find the FROM");
            setCols.token.setType(837);
            return;
        }
        String alias = null;
        if (fromNode.getChildCount() > 0 && (fromWhat = fromNode.getChild(0)).getType() == 1236 && fromWhat.getChildCount() > 1 && (child = fromWhat.getChild(fromWhat.getChildCount() - 1)).getType() == 24) {
            alias = child.getText();
        }
        if ((select = searcher.simpleBreadthFirstSearchAny((ASTNode)fromNode, 1190, 1191)) == null) {
            LOG.debug("Replacing SETCOLREF with ALLCOLREF because we couldn't find the SELECT");
            setCols.token.setType(837);
            return;
        }
        while (true) {
            CommonTree queryOfSelect = select.parent;
            while (queryOfSelect != null && queryOfSelect.getType() != 1155) {
                queryOfSelect = queryOfSelect.parent;
            }
            if (queryOfSelect == null || queryOfSelect.parent == null) {
                LOG.debug("Replacing SETCOLREF with ALLCOLREF because we couldn't find the QUERY");
                setCols.token.setType(837);
                return;
            }
            if (queryOfSelect.childIndex == 0) break;
            Tree moreToTheLeft = queryOfSelect.parent.getChild(0);
            Preconditions.checkState((moreToTheLeft != queryOfSelect ? 1 : 0) != 0);
            ASTNode newSelect = searcher.simpleBreadthFirstSearchAny((ASTNode)moreToTheLeft, 1190, 1191);
            Preconditions.checkState((newSelect != select ? 1 : 0) != 0);
            select = newSelect;
        }
        ArrayList<ASTNode> newChildren = new ArrayList<ASTNode>(select.getChildCount());
        HashSet<String> aliases = new HashSet<String>();
        for (int i = 0; i < select.getChildCount(); ++i) {
            int start;
            Tree selExpr = select.getChild(i);
            if (selExpr.getType() == 427) continue;
            assert (selExpr.getType() == 1192);
            assert (selExpr.getChildCount() > 0);
            boolean isFunctionWithMultipleParameters = selExpr.getChild(0).getType() == 1035 && selExpr.getChildCount() > 2;
            block12: for (int j = start = isFunctionWithMultipleParameters ? 1 : selExpr.getChildCount() - 1; j < selExpr.getChildCount(); ++j) {
                Tree child3 = selExpr.getChild(j);
                switch (child3.getType()) {
                    case 1197: {
                        ParseUtils.processSetColsNode((ASTNode)child3, searcher, ctx);
                        ParseUtils.processSetColsNode(setCols, searcher, ctx);
                        return;
                    }
                    case 837: {
                        LOG.debug("Replacing SETCOLREF with ALLCOLREF because of nested ALLCOLREF");
                        setCols.token.setType(837);
                        return;
                    }
                    case 1270: {
                        Tree idChild = child3.getChild(0);
                        assert (idChild.getType() == 24) : idChild;
                        if (ParseUtils.createChildColumnRef(idChild, alias, newChildren, aliases, ctx)) continue block12;
                        setCols.token.setType(837);
                        return;
                    }
                    case 24: {
                        if (ParseUtils.createChildColumnRef(child3, alias, newChildren, aliases, ctx)) continue block12;
                        setCols.token.setType(837);
                        return;
                    }
                    case 16: {
                        Tree colChild = child3.getChild(child3.getChildCount() - 1);
                        assert (colChild.getType() == 24) : colChild;
                        if (ParseUtils.createChildColumnRef(colChild, alias, newChildren, aliases, ctx)) continue block12;
                        setCols.token.setType(837);
                        return;
                    }
                    default: {
                        LOG.debug("Replacing SETCOLREF with ALLCOLREF because of the nested node " + child3.getType() + " " + child3.getText());
                        setCols.token.setType(837);
                        return;
                    }
                }
            }
        }
        ASTNode parent = (ASTNode)setCols.parent.parent;
        int t = parent.getType();
        assert (t == 1190 || t == 1191) : t;
        int ix = setCols.parent.childIndex;
        parent.deleteChild(ix);
        for (ASTNode node : newChildren) {
            parent.insertChild(ix++, (Object)node);
        }
    }

    private static boolean createChildColumnRef(Tree child, String alias, List<ASTNode> newChildren, Set<String> aliases, Context ctx) {
        String colAlias = child.getText();
        if (SemanticAnalyzer.isRegex(colAlias, (HiveConf)ctx.getConf())) {
            LOG.debug("Skip creating child column reference because of regexp used as alias: " + colAlias);
            return false;
        }
        if (!aliases.add(colAlias)) {
            LOG.debug("Replacing SETCOLREF with ALLCOLREF because of duplicate alias " + colAlias);
            return false;
        }
        ASTBuilder selExpr = ASTBuilder.construct(1192, "TOK_SELEXPR");
        ASTBuilder toc = ASTBuilder.construct(1270, "TOK_TABLE_OR_COL");
        ASTBuilder id = ASTBuilder.construct(24, colAlias);
        if (alias == null) {
            selExpr = selExpr.add(toc.add(id));
        } else {
            ASTBuilder dot = ASTBuilder.construct(16, ".");
            ASTBuilder aliasNode = ASTBuilder.construct(24, alias);
            selExpr = selExpr.add(dot.add(toc.add(aliasNode)).add(id));
        }
        newChildren.add(selExpr.node());
        return true;
    }

    public static String getKeywords(Set<String> excludes) {
        StringBuilder sb = new StringBuilder();
        for (Field f : HiveLexer.class.getDeclaredFields()) {
            String name;
            if (!Modifier.isStatic(f.getModifiers()) || !(name = f.getName()).startsWith("KW_")) continue;
            name = name.substring(3);
            if (excludes != null && excludes.contains(name)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    public static CBOPlan parseQuery(Context ctx, String viewQuery) throws SemanticException, ParseException {
        ASTNode ast = ParseUtils.parse(viewQuery, ctx);
        CalcitePlanner analyzer = ParseUtils.getAnalyzer((HiveConf)ctx.getConf(), ctx);
        RelNode logicalPlan = analyzer.genLogicalPlan(ast);
        return new CBOPlan(ast, logicalPlan, analyzer.getMaterializationValidationResult().getSupportedRewriteAlgorithms());
    }

    public static List<FieldSchema> parseQueryAndGetSchema(HiveConf conf, String viewQuery) throws SemanticException, ParseException {
        Context ctx = new Context((Configuration)conf);
        ctx.setIsLoadingMaterializedView(true);
        ASTNode ast = ParseUtils.parse(viewQuery, ctx);
        CalcitePlanner analyzer = ParseUtils.getAnalyzer(conf, ctx);
        analyzer.analyze(ast, ctx);
        return analyzer.getResultSchema();
    }

    private static CalcitePlanner getAnalyzer(HiveConf conf, Context ctx) throws SemanticException {
        QueryState qs = new QueryState.Builder().withHiveConf(conf).build();
        CalcitePlanner analyzer = new CalcitePlanner(qs);
        analyzer.initCtx(ctx);
        analyzer.init(false);
        return analyzer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<Integer, List<ExprNodeGenericFuncDesc>> getFullPartitionSpecs(CommonTree ast, Table table, Configuration conf, boolean canGroupExprs) throws SemanticException {
        String defaultPartitionName = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULT_PARTITION_NAME);
        HashMap<String, String> colTypes = new HashMap<String, String>();
        List<FieldSchema> partitionKeys = table.hasNonNativePartitionSupport() ? table.getStorageHandler().getPartitionKeys(table) : table.getPartitionKeys();
        for (FieldSchema fs : partitionKeys) {
            colTypes.put(fs.getName().toLowerCase(), fs.getType());
        }
        HashMap<Integer, List<ExprNodeGenericFuncDesc>> result = new HashMap<Integer, List<ExprNodeGenericFuncDesc>>();
        for (int childIndex = 0; childIndex < ast.getChildCount(); ++childIndex) {
            Tree partSpecTree = ast.getChild(childIndex);
            if (partSpecTree.getType() != 1132) continue;
            ExprNodeGenericFuncDesc expr = null;
            HashSet<String> names = new HashSet<String>(partSpecTree.getChildCount());
            for (int i = 0; i < partSpecTree.getChildCount(); ++i) {
                ExprNodeGenericFuncDesc op;
                String type;
                String key;
                CommonTree partSpecSingleKey = (CommonTree)partSpecTree.getChild(i);
                assert (partSpecSingleKey.getType() == 1133);
                String transform = null;
                Tree partitionTree = partSpecSingleKey.getChild(0);
                if (partitionTree.getType() == 1035) {
                    int childCount = partitionTree.getChildCount();
                    if (childCount == 2) {
                        key = ParseUtils.stripIdentifierQuotes(partitionTree.getChild(1).getText()).toLowerCase();
                        transform = partitionTree.getChild(0).getText().toLowerCase() + "(" + key + ")";
                    } else {
                        if (childCount != 3) throw new SemanticException("Unexpected number of children in partition spec");
                        key = ParseUtils.stripIdentifierQuotes(partitionTree.getChild(2).getText()).toLowerCase();
                        String transformParam = partitionTree.getChild(1).getText();
                        transform = partitionTree.getChild(0).getText().toLowerCase() + "(" + transformParam + ", " + key + ")";
                    }
                } else {
                    key = ParseUtils.stripIdentifierQuotes(partitionTree.getText()).toLowerCase();
                }
                String operator = partSpecSingleKey.getChild(1).getText();
                ASTNode partValNode = (ASTNode)partSpecSingleKey.getChild(2);
                TypeCheckCtx typeCheckCtx = new TypeCheckCtx(null);
                ExprNodeConstantDesc valExpr = (ExprNodeConstantDesc)ExprNodeTypeCheck.genExprNode(partValNode, typeCheckCtx).get(partValNode);
                Object val = valExpr.getValue();
                boolean isDefaultPartitionName = val.equals(defaultPartitionName);
                String string = type = transform != null ? "string" : (String)colTypes.get(key);
                if (type == null) {
                    throw new SemanticException("Column " + key + " is not a partition key");
                }
                PrimitiveTypeInfo pti = TypeInfoFactory.getPrimitiveTypeInfo((String)type);
                if (!isDefaultPartitionName && !valExpr.getTypeString().equals(type)) {
                    ObjectInspectorConverters.Converter converter = ObjectInspectorConverters.getConverter((ObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)valExpr.getTypeInfo()), (ObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)pti));
                    val = converter.convert(valExpr.getValue());
                }
                ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)pti, (String)ObjectUtils.defaultIfNull((Object)transform, (Object)key), null, true);
                if (!isDefaultPartitionName) {
                    op = PartitionUtils.makeBinaryPredicate(operator, column, new ExprNodeConstantDesc((TypeInfo)pti, val));
                } else {
                    String fnName;
                    GenericUDF originalOp = FunctionRegistry.getFunctionInfo(operator).getGenericUDF();
                    if (FunctionRegistry.isEq(originalOp)) {
                        fnName = "isnull";
                    } else {
                        if (!FunctionRegistry.isNeq(originalOp)) throw new SemanticException("Cannot use " + operator + " in a default partition spec; only '=' and '!=' are allowed.");
                        fnName = "isnotnull";
                    }
                    op = PartitionUtils.makeUnaryPredicate(fnName, column);
                }
                expr = expr == null ? op : PartitionUtils.makeBinaryPredicate("and", expr, op);
                names.add(key);
            }
            if (expr == null) continue;
            int prefixLength = ParseUtils.calculatePartPrefix(table, names);
            List orExpr = (List)result.get(prefixLength);
            if (orExpr == null) {
                result.put(prefixLength, Lists.newArrayList((Object[])new ExprNodeGenericFuncDesc[]{expr}));
                continue;
            }
            if (canGroupExprs) {
                orExpr.set(0, PartitionUtils.makeBinaryPredicate("or", expr, (ExprNodeDesc)orExpr.get(0)));
                continue;
            }
            orExpr.add(expr);
        }
        return result;
    }

    private static int calculatePartPrefix(Table tbl, Set<String> partSpecKeys) {
        int partPrefixToDrop = 0;
        for (FieldSchema fs : tbl.getPartCols()) {
            if (!partSpecKeys.contains(fs.getName())) break;
            ++partPrefixToDrop;
        }
        return partPrefixToDrop;
    }

    public static String stripIdentifierQuotes(String val) {
        if (val.charAt(0) == '`' && val.charAt(val.length() - 1) == '`') {
            val = val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static ReparseResult parseRewrittenQuery(Context ctx, StringBuilder rewrittenQueryStr) throws SemanticException {
        return ParseUtils.parseRewrittenQuery(ctx, rewrittenQueryStr.toString());
    }

    public static ReparseResult parseRewrittenQuery(Context ctx, String rewrittenQueryStr) throws SemanticException {
        ASTNode rewrittenTree;
        HiveConf.setVar((Configuration)ctx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.DYNAMIC_PARTITIONING_MODE, (String)"nonstrict");
        HiveConf.setBoolVar((Configuration)ctx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ROW_WRAPPER_ENABLED, (boolean)false);
        Context rewrittenCtx = new Context(ctx.getConf());
        rewrittenCtx.setHDFSCleanup(true);
        ctx.addSubContext(rewrittenCtx);
        rewrittenCtx.setExplainConfig(ctx.getExplainConfig());
        rewrittenCtx.setExplainPlan(ctx.isExplainPlan());
        rewrittenCtx.setStatsSource(ctx.getStatsSource());
        rewrittenCtx.setPlanMapper(ctx.getPlanMapper());
        rewrittenCtx.setIsUpdateDeleteMerge(true);
        rewrittenCtx.setCmd(rewrittenQueryStr);
        try {
            LOG.info("Going to reparse <{}> as \n<{}>", (Object)ctx.getCmd(), (Object)rewrittenQueryStr);
            rewrittenTree = ParseUtils.parse(rewrittenQueryStr, rewrittenCtx);
        }
        catch (ParseException e) {
            throw new SemanticException(ErrorMsg.UPDATEDELETE_PARSE_ERROR.getMsg(), (Throwable)e);
        }
        return new ReparseResult(rewrittenTree, rewrittenCtx);
    }

    public static TypeInfo getComplexTypeTypeInfo(ASTNode typeNode) throws SemanticException {
        switch (typeNode.getType()) {
            case 1085: {
                ListTypeInfo listTypeInfo = new ListTypeInfo();
                listTypeInfo.setListElementTypeInfo(ParseUtils.getComplexTypeTypeInfo((ASTNode)typeNode.getChild(0)));
                return listTypeInfo;
            }
            case 1089: {
                MapTypeInfo mapTypeInfo = new MapTypeInfo();
                String keyTypeString = BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)typeNode.getChild(0));
                mapTypeInfo.setMapKeyTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)keyTypeString));
                mapTypeInfo.setMapValueTypeInfo(ParseUtils.getComplexTypeTypeInfo((ASTNode)typeNode.getChild(1)));
                return mapTypeInfo;
            }
            case 1235: {
                StructTypeInfo structTypeInfo = new StructTypeInfo();
                Map<String, TypeInfo> fields = ParseUtils.collectStructFieldNames(typeNode);
                structTypeInfo.setAllStructFieldNames(new ArrayList<String>(fields.keySet()));
                structTypeInfo.setAllStructFieldTypeInfos(new ArrayList<TypeInfo>(fields.values()));
                return structTypeInfo;
            }
        }
        String typeString = BaseSemanticAnalyzer.getTypeStringFromAST(typeNode);
        return TypeInfoFactory.getPrimitiveTypeInfo((String)typeString);
    }

    private static Map<String, TypeInfo> collectStructFieldNames(ASTNode structTypeNode) throws SemanticException {
        ASTNode fieldListNode = (ASTNode)structTypeNode.getChild(0);
        assert (fieldListNode.getType() == 1246);
        LinkedHashMap<String, TypeInfo> result = new LinkedHashMap<String, TypeInfo>(fieldListNode.getChildCount());
        for (int i = 0; i < fieldListNode.getChildCount(); ++i) {
            ASTNode child = (ASTNode)fieldListNode.getChild(i);
            String attributeIdentifier = BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
            if (result.containsKey(attributeIdentifier)) {
                throw new SemanticException(ErrorMsg.AMBIGUOUS_STRUCT_ATTRIBUTE, new String[]{attributeIdentifier});
            }
            result.put(attributeIdentifier, ParseUtils.getComplexTypeTypeInfo((ASTNode)child.getChild(1)));
        }
        return result;
    }

    public static String getNodeName(ASTNode node) {
        return Optional.ofNullable(node).map(CommonTree::getText).map(text -> text.substring("TOK_".length())).orElse("");
    }

    public static final class ReparseResult {
        public final ASTNode rewrittenTree;
        public final Context rewrittenCtx;

        ReparseResult(ASTNode n, Context c) {
            this.rewrittenTree = n;
            this.rewrittenCtx = c;
        }
    }
}

