/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveOpConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveOpConverterUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveRelNodeVisitor;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;

class HiveSortLimitVisitor
extends HiveRelNodeVisitor<HiveSortLimit> {
    HiveSortLimitVisitor(HiveOpConverter hiveOpConverter) {
        super(hiveOpConverter);
    }

    @Override
    HiveOpConverter.OpAttr visit(HiveSortLimit sortRel) throws SemanticException {
        HiveOpConverter.OpAttr inputOpAf = this.hiveOpConverter.dispatch(sortRel.getInput());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translating operator rel#" + sortRel.getId() + ":" + sortRel.getRelTypeName() + " with row type: [" + sortRel.getRowType() + "]");
            if (sortRel.getCollation() == RelCollations.EMPTY) {
                LOG.debug("Operator rel#" + sortRel.getId() + ":" + sortRel.getRelTypeName() + " consists of limit");
            } else if (sortRel.fetch == null) {
                LOG.debug("Operator rel#" + sortRel.getId() + ":" + sortRel.getRelTypeName() + " consists of sort");
            } else {
                LOG.debug("Operator rel#" + sortRel.getId() + ":" + sortRel.getRelTypeName() + " consists of sort+limit");
            }
        }
        Operator inputOp = (Operator)inputOpAf.inputs.get(0);
        SelectOperator resultOp = (SelectOperator)inputOpAf.inputs.get(0);
        if (sortRel.getCollation() != RelCollations.EMPTY) {
            String error;
            if (sortRel.fetch == null && (error = HiveConf.StrictChecks.checkNoLimit((Configuration)this.hiveOpConverter.getHiveConf())) != null) {
                throw new SemanticException(error);
            }
            ImmutableBitSet.Builder sortColsPosBuilder = ImmutableBitSet.builder();
            ImmutableBitSet.Builder sortOutputColsPosBuilder = ImmutableBitSet.builder();
            Map<Integer, RexNode> obRefToCallMap = sortRel.getInputRefToCallMap();
            ArrayList<ExprNodeColumnDesc> sortCols = new ArrayList<ExprNodeColumnDesc>();
            StringBuilder order = new StringBuilder();
            StringBuilder nullOrder = new StringBuilder();
            for (RelFieldCollation sortInfo : sortRel.getCollation().getFieldCollations()) {
                int sortColumnPos = sortInfo.getFieldIndex();
                ColumnInfo columnInfo = new ColumnInfo(inputOp.getSchema().getSignature().get(sortColumnPos));
                ExprNodeColumnDesc sortColumn = new ExprNodeColumnDesc(columnInfo.getType(), columnInfo.getInternalName(), columnInfo.getTabAlias(), columnInfo.getIsVirtualCol());
                sortCols.add(sortColumn);
                if (sortInfo.getDirection() == RelFieldCollation.Direction.DESCENDING) {
                    order.append("-");
                } else {
                    order.append("+");
                }
                if (sortInfo.nullDirection == RelFieldCollation.NullDirection.FIRST) {
                    nullOrder.append("a");
                } else if (sortInfo.nullDirection == RelFieldCollation.NullDirection.LAST) {
                    nullOrder.append("z");
                } else {
                    nullOrder.append(sortInfo.getDirection() == RelFieldCollation.Direction.DESCENDING ? "z" : "a");
                }
                if (obRefToCallMap == null) continue;
                RexNode obExpr = obRefToCallMap.get(sortColumnPos);
                sortColsPosBuilder.set(sortColumnPos);
                if (obExpr != null) continue;
                sortOutputColsPosBuilder.set(sortColumnPos);
            }
            int numReducers = 1;
            ArrayList<String> keepColumns = new ArrayList<String>();
            ImmutableBitSet sortColsPos = sortColsPosBuilder.build();
            ImmutableBitSet sortOutputColsPos = sortOutputColsPosBuilder.build();
            List<ColumnInfo> inputSchema = inputOp.getSchema().getSignature();
            for (int pos = 0; pos < inputSchema.size(); ++pos) {
                if ((!sortColsPos.get(pos) || !sortOutputColsPos.get(pos)) && (sortColsPos.get(pos) || sortOutputColsPos.get(pos))) continue;
                keepColumns.add(inputSchema.get(pos).getInternalName());
            }
            resultOp = HiveOpConverterUtils.genReduceSinkAndBacktrackSelect(resultOp, sortCols.toArray(new ExprNodeDesc[sortCols.size()]), 0, new ArrayList<ExprNodeDesc>(), order.toString(), nullOrder.toString(), numReducers, AcidUtils.Operation.NOT_ACID, this.hiveOpConverter.getHiveConf(), keepColumns);
        }
        if (sortRel.fetch != null) {
            int limit = RexLiteral.intValue((RexNode)sortRel.fetch);
            int offset = sortRel.offset == null ? 0 : RexLiteral.intValue((RexNode)sortRel.offset);
            LimitDesc limitDesc = new LimitDesc(offset, limit);
            ArrayList<ColumnInfo> cinfoLst = HiveOpConverterUtils.createColInfos(resultOp);
            resultOp = OperatorFactory.getAndMakeChild(limitDesc, new RowSchema(cinfoLst), (Operator)resultOp, new Operator[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Generated " + resultOp + " with row schema: [" + resultOp.getSchema() + "]");
            }
        }
        return inputOpAf.clone(resultOp);
    }
}

