/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;

public class HiveFilterProjectTransposeRule
extends FilterProjectTransposeRule {
    public static final HiveFilterProjectTransposeRule DETERMINISTIC_WINDOWING_ON_NON_FILTERING_JOIN = new HiveFilterProjectTransposeRule(HiveFilterProjectTransposeRule.operand(Filter.class, (RelOptRuleOperand)HiveFilterProjectTransposeRule.operand(Project.class, (RelOptRuleOperand)HiveFilterProjectTransposeRule.operand(Join.class, (RelOptRuleOperandChildren)HiveFilterProjectTransposeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), HiveRelFactories.HIVE_BUILDER, true, true, 100);
    public static final HiveFilterProjectTransposeRule DETERMINISTIC_WINDOWING = new HiveFilterProjectTransposeRule(Filter.class, HiveProject.class, HiveRelFactories.HIVE_BUILDER, true, true, 100);
    public static final HiveFilterProjectTransposeRule DETERMINISTIC_ON_NON_FILTERING_JOIN = new HiveFilterProjectTransposeRule(HiveFilterProjectTransposeRule.operand(Filter.class, (RelOptRuleOperand)HiveFilterProjectTransposeRule.operand(Project.class, (RelOptRuleOperand)HiveFilterProjectTransposeRule.operand(Join.class, (RelOptRuleOperandChildren)HiveFilterProjectTransposeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), HiveRelFactories.HIVE_BUILDER, true, false, 100);
    public static final HiveFilterProjectTransposeRule DETERMINISTIC = new HiveFilterProjectTransposeRule(Filter.class, HiveProject.class, HiveRelFactories.HIVE_BUILDER, true, false, 100);
    public static final HiveFilterProjectTransposeRule INSTANCE = new HiveFilterProjectTransposeRule(Filter.class, HiveProject.class, HiveRelFactories.HIVE_BUILDER, false, false, 100);
    private final boolean onlyDeterministic;
    private final boolean pushThroughWindowing;
    private final int bloat;

    private HiveFilterProjectTransposeRule(Class<? extends Filter> filterClass, Class<? extends Project> projectClass, RelBuilderFactory relBuilderFactory, boolean onlyDeterministic, boolean pushThroughWindowing, int bloat) {
        super(filterClass, projectClass, false, false, relBuilderFactory);
        this.onlyDeterministic = onlyDeterministic;
        this.pushThroughWindowing = pushThroughWindowing;
        this.bloat = bloat;
    }

    private HiveFilterProjectTransposeRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, boolean onlyDeterministic, boolean pushThroughWindowing, int bloat) {
        super(operand, false, false, relBuilderFactory);
        this.onlyDeterministic = onlyDeterministic;
        this.pushThroughWindowing = pushThroughWindowing;
        this.bloat = bloat;
    }

    public boolean matches(RelOptRuleCall call) {
        Filter filterRel = (Filter)call.rel(0);
        RexNode condition = HiveRelOptUtil.pushPastProjectUnlessBloat(filterRel.getCondition(), (Project)call.rel(1), this.bloat);
        if (condition == null) {
            return false;
        }
        if (this.onlyDeterministic && !HiveCalciteUtil.isDeterministic(condition)) {
            return false;
        }
        if (call.rels.length > 2) {
            Join joinRel = (Join)call.rel(2);
            HiveRelOptUtil.RewritablePKFKJoinInfo joinInfo = HiveRelOptUtil.isRewritablePKFKJoin(joinRel, joinRel.getLeft(), joinRel.getRight(), call.getMetadataQuery());
            if (!joinInfo.rewritable) {
                return false;
            }
        }
        return super.matches(call);
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode newProjRel;
        Filter filter = (Filter)call.rel(0);
        Project origproject = (Project)call.rel(1);
        RexNode filterCondToPushBelowProj = filter.getCondition();
        RexNode unPushedFilCondAboveProj = null;
        if (RexUtil.containsCorrelation((RexNode)filterCondToPushBelowProj)) {
            return;
        }
        if (RexOver.containsOver((List)origproject.getProjects(), null)) {
            RexNode origFilterCond = filterCondToPushBelowProj;
            filterCondToPushBelowProj = null;
            if (this.pushThroughWindowing) {
                Set<Integer> commonPartitionKeys = HiveFilterProjectTransposeRule.getCommonPartitionCols(origproject.getProjects());
                ArrayList<RexNode> newPartKeyFilConds = new ArrayList<RexNode>();
                ArrayList<RexNode> unpushedFilConds = new ArrayList<RexNode>();
                if (!commonPartitionKeys.isEmpty()) {
                    for (RexNode ce : RelOptUtil.conjunctions((RexNode)origFilterCond)) {
                        RexNode newCondition = HiveRelOptUtil.pushPastProjectUnlessBloat(ce, origproject, this.bloat);
                        if (newCondition != null && HiveCalciteUtil.isDeterministicFuncWithSingleInputRef(newCondition, commonPartitionKeys)) {
                            newPartKeyFilConds.add(ce);
                            continue;
                        }
                        unpushedFilConds.add(ce);
                    }
                    if (!newPartKeyFilConds.isEmpty()) {
                        filterCondToPushBelowProj = RexUtil.composeConjunction((RexBuilder)filter.getCluster().getRexBuilder(), newPartKeyFilConds, (boolean)true);
                    }
                    if (!unpushedFilConds.isEmpty()) {
                        unPushedFilCondAboveProj = RexUtil.composeConjunction((RexBuilder)filter.getCluster().getRexBuilder(), unpushedFilConds, (boolean)true);
                    }
                }
            }
        }
        if (filterCondToPushBelowProj != null && !this.isRedundantIsNotNull(origproject, filterCondToPushBelowProj) && (newProjRel = this.getNewProject(filterCondToPushBelowProj, unPushedFilCondAboveProj, origproject, filter.getCluster().getTypeFactory(), call.builder())) != null) {
            call.transformTo(newProjRel);
        }
    }

    private RelNode getNewProject(RexNode filterCondToPushBelowProj, RexNode unPushedFilCondAboveProj, Project oldProj, RelDataTypeFactory typeFactory, RelBuilder relBuilder) {
        RexNode newPushedCondition = HiveRelOptUtil.pushPastProjectUnlessBloat(filterCondToPushBelowProj, oldProj, this.bloat);
        if (newPushedCondition == null) {
            return null;
        }
        if (RexUtil.isNullabilityCast((RelDataTypeFactory)typeFactory, (RexNode)newPushedCondition)) {
            newPushedCondition = (RexNode)((RexCall)newPushedCondition).getOperands().get(0);
        }
        RelNode newPushedFilterRel = relBuilder.push(oldProj.getInput()).filter(new RexNode[]{newPushedCondition}).build();
        RelNode newProjRel = relBuilder.push(newPushedFilterRel).project((Iterable)oldProj.getProjects(), (Iterable)oldProj.getRowType().getFieldNames()).build();
        if (unPushedFilCondAboveProj != null) {
            if (RexUtil.isNullabilityCast((RelDataTypeFactory)typeFactory, (RexNode)newPushedCondition)) {
                unPushedFilCondAboveProj = (RexNode)((RexCall)unPushedFilCondAboveProj).getOperands().get(0);
            }
            newProjRel = relBuilder.push(newProjRel).filter(new RexNode[]{unPushedFilCondAboveProj}).build();
        }
        return newProjRel;
    }

    private static Set<Integer> getCommonPartitionCols(List<RexNode> projections) {
        boolean firstOverClause = true;
        HashSet<Integer> commonPartitionKeys = new HashSet<Integer>();
        for (RexNode expr : projections) {
            if (!(expr instanceof RexOver)) continue;
            RexOver overClause = (RexOver)expr;
            if (firstOverClause) {
                firstOverClause = false;
                commonPartitionKeys.addAll(HiveFilterProjectTransposeRule.getPartitionCols((List<RexNode>)overClause.getWindow().partitionKeys));
                continue;
            }
            commonPartitionKeys.retainAll(HiveFilterProjectTransposeRule.getPartitionCols((List<RexNode>)overClause.getWindow().partitionKeys));
        }
        return commonPartitionKeys;
    }

    private static List<Integer> getPartitionCols(List<RexNode> partitionKeys) {
        ArrayList<Integer> pCols = new ArrayList<Integer>();
        for (RexNode key : partitionKeys) {
            if (!(key instanceof RexInputRef)) continue;
            pCols.add(((RexInputRef)key).getIndex());
        }
        return pCols;
    }

    private boolean isRedundantIsNotNull(Project project, RexNode newCondition) {
        if (!newCondition.isA(SqlKind.IS_NOT_NULL)) {
            return false;
        }
        if (HiveCalciteUtil.getInputRefs(newCondition).size() != 1) {
            return false;
        }
        RedundancyChecker redundancyChecker = new RedundancyChecker(newCondition, this.bloat);
        redundancyChecker.go((RelNode)project);
        return redundancyChecker.isRedundant;
    }

    private static boolean isPredicateIncluded(RexNode includedPred, RexNode containingPred) {
        SubsumptionChecker inclusionChecker = new SubsumptionChecker(includedPred);
        return (Boolean)containingPred.accept((RexVisitor)inclusionChecker);
    }

    private static class RedundancyChecker
    extends RelVisitor {
        private boolean isRedundant;
        final RexNode newCondition;
        final Map<RelNode, RexNode> filter2newConditionMap = new HashMap<RelNode, RexNode>();
        private final int bloat;

        protected RedundancyChecker(RexNode newCondition, int bloat) {
            this.newCondition = newCondition;
            this.bloat = bloat;
        }

        public void visit(RelNode node, int ordinal, RelNode parent) {
            RexNode filterCondition;
            RexNode rexNode = filterCondition = this.filter2newConditionMap.isEmpty() ? this.newCondition : this.filter2newConditionMap.get(node);
            if (this.isRedundant) {
                return;
            }
            if (node instanceof HepRelVertex) {
                RelNode currNode = ((HepRelVertex)node).getCurrentRel();
                this.filter2newConditionMap.put(currNode, this.filter2newConditionMap.remove(node));
                this.visit(currNode, ordinal, parent);
            } else {
                if (node instanceof Filter) {
                    this.check((Filter)node);
                } else if (node instanceof Project) {
                    RexNode condition = HiveRelOptUtil.pushPastProjectUnlessBloat(filterCondition, (Project)node, this.bloat);
                    if (condition != null) {
                        filterCondition = condition;
                    }
                } else {
                    return;
                }
                RexNode finalFilterCondition = filterCondition;
                node.getInputs().forEach(i -> this.filter2newConditionMap.put((RelNode)i, finalFilterCondition));
                super.visit(node, ordinal, parent);
            }
        }

        private void check(Filter filter) {
            RelOptCluster cluster = filter.getCluster();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            RexSimplify simplify = new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, (RexExecutor)Util.first((Object)cluster.getPlanner().getExecutor(), (Object)RexUtil.EXECUTOR));
            RexNode newCondition = simplify.simplify(this.filter2newConditionMap.get(filter));
            if (RexUtil.isLiteral((RexNode)newCondition, (boolean)true)) {
                return;
            }
            if (newCondition instanceof RexCall && ((RexNode)((RexCall)newCondition).getOperands().get(0)).isA(SqlKind.INPUT_REF)) {
                return;
            }
            RexNode filterCondition = simplify.simplify(filter.getCondition());
            Set<Integer> inputRefs = HiveCalciteUtil.getInputRefs(newCondition);
            if (inputRefs.isEmpty()) {
                return;
            }
            RexInputRef rexInputRef = rexBuilder.makeInputRef(filter.getInput(), inputRefs.iterator().next().intValue());
            RexNode baseCondition = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{rexInputRef});
            if (newCondition.toString().equals(filterCondition.toString())) {
                return;
            }
            this.isRedundant = !HiveFilterProjectTransposeRule.isPredicateIncluded(newCondition, filterCondition) && HiveFilterProjectTransposeRule.isPredicateIncluded(baseCondition, filterCondition);
        }
    }

    private static class SubsumptionChecker
    extends RexVisitorImpl<Boolean> {
        private final String includedPredDigest;

        protected SubsumptionChecker(RexNode includedPred) {
            super(true);
            this.includedPredDigest = includedPred.toString();
        }

        public Boolean visitInputRef(RexInputRef inputRef) {
            return false;
        }

        public Boolean visitLiteral(RexLiteral literal) {
            return false;
        }

        public Boolean visitCorrelVariable(RexCorrelVariable correlVariable) {
            return false;
        }

        public Boolean visitCall(RexCall call) {
            if (call.isA(SqlKind.AND)) {
                return call.getOperands().stream().anyMatch(o -> (Boolean)o.accept((RexVisitor)this));
            }
            if (call.isA(SqlKind.OR)) {
                return call.getOperands().stream().allMatch(o -> (Boolean)o.accept((RexVisitor)this));
            }
            return this.includedPredDigest.equals(call.toString());
        }

        public Boolean visitDynamicParam(RexDynamicParam dynamicParam) {
            return false;
        }

        public Boolean visitRangeRef(RexRangeRef rangeRef) {
            return false;
        }

        public Boolean visitFieldAccess(RexFieldAccess fieldAccess) {
            return false;
        }
    }
}

