/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.Multimap;
import java.util.function.Predicate;
import org.apache.calcite.plan.CommonRelSubExprRule;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hadoop.hive.ql.optimizer.calcite.CommonTableExpressionRegistry;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRuleConfig;

public final class CommonRelSubExprRegisterRule
extends CommonRelSubExprRule {
    public static final CommonRelSubExprRegisterRule JOIN = new CommonRelSubExprRegisterRule(o -> o.operand(Join.class).predicate(j -> JoinRelType.INNER == j.getJoinType()).anyInputs());
    public static final CommonRelSubExprRegisterRule AGGREGATE = new CommonRelSubExprRegisterRule(o -> o.operand(Aggregate.class).anyInputs());
    public static final CommonRelSubExprRegisterRule FILTER = new CommonRelSubExprRegisterRule(o -> o.operand(Filter.class).anyInputs());
    public static final CommonRelSubExprRegisterRule PROJECT = new CommonRelSubExprRegisterRule(o -> o.operand(Project.class).predicate((Predicate)new InterestingRelNodePredicate()).anyInputs());

    private CommonRelSubExprRegisterRule(RelRule.OperandTransform operands) {
        super((CommonRelSubExprRule.Config)new Config().withOperandSupplier(operands).as(Config.class));
    }

    public void onMatch(RelOptRuleCall call) {
        CommonTableExpressionRegistry r = (CommonTableExpressionRegistry)call.getPlanner().getContext().unwrap(CommonTableExpressionRegistry.class);
        r.add(call.rel(0));
    }

    private static class Config
    extends HiveRuleConfig
    implements CommonRelSubExprRule.Config {
        private Config() {
        }

        public RelOptRule toRule() {
            return new CommonRelSubExprRegisterRule(this.operandSupplier());
        }
    }

    private static final class InterestingRelNodePredicate
    implements Predicate<RelNode> {
        private InterestingRelNodePredicate() {
        }

        @Override
        public boolean test(RelNode rel) {
            RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
            Multimap types = mq.getNodeTypes(rel);
            if (types == null) {
                return false;
            }
            return types.keySet().stream().anyMatch(t -> Join.class.isAssignableFrom((Class<?>)t) || Aggregate.class.isAssignableFrom((Class<?>)t) || Filter.class.isAssignableFrom((Class<?>)t));
        }
    }
}

