/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Set;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFloorDate;

public class HiveRelBuilder
extends RelBuilder {
    private HiveRelBuilder(Context context, RelOptCluster cluster, RelOptSchema relOptSchema) {
        super(context, cluster, relOptSchema);
    }

    public static RelBuilder create(FrameworkConfig config) {
        final RelOptCluster[] clusters = new RelOptCluster[]{null};
        final RelOptSchema[] relOptSchemas = new RelOptSchema[]{null};
        Frameworks.withPrepare((Frameworks.PrepareAction)new Frameworks.PrepareAction<Void>(config){

            public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, CalciteServerStatement statement) {
                clusters[0] = cluster;
                relOptSchemas[0] = relOptSchema;
                return null;
            }
        });
        return new HiveRelBuilder(config.getContext(), clusters[0], relOptSchemas[0]);
    }

    public static RelBuilderFactory proto(final Context context) {
        return new RelBuilderFactory(){

            public RelBuilder create(RelOptCluster cluster, RelOptSchema schema) {
                Context confContext = Contexts.of((Object)RelBuilder.Config.DEFAULT.withPruneInputOfAggregate(false));
                return new HiveRelBuilder(Contexts.chain((Context[])new Context[]{context, confContext}), cluster, schema);
            }
        };
    }

    public static RelBuilderFactory proto(Object ... factories) {
        return HiveRelBuilder.proto(Contexts.of((Object[])factories));
    }

    public RelBuilder filter(Iterable<? extends RexNode> predicates) {
        RexNode x = RexUtil.composeConjunction((RexBuilder)this.cluster.getRexBuilder(), predicates, (boolean)false);
        if (!x.isAlwaysTrue()) {
            RelNode input = this.build();
            RelNode filter = HiveRelFactories.HIVE_FILTER_FACTORY.createFilter(input, x);
            return this.push(filter);
        }
        return this;
    }

    public static SqlFunction getFloorSqlFunction(TimeUnitRange flag) {
        switch (flag) {
            case YEAR: {
                return HiveFloorDate.YEAR;
            }
            case QUARTER: {
                return HiveFloorDate.QUARTER;
            }
            case MONTH: {
                return HiveFloorDate.MONTH;
            }
            case DAY: {
                return HiveFloorDate.DAY;
            }
            case HOUR: {
                return HiveFloorDate.HOUR;
            }
            case MINUTE: {
                return HiveFloorDate.MINUTE;
            }
            case SECOND: {
                return HiveFloorDate.SECOND;
            }
        }
        return SqlStdOperatorTable.FLOOR;
    }

    public RelBuilder join(JoinRelType joinType, RexNode condition, Set<CorrelationId> variablesSet) {
        RelNode right = this.peek(0);
        RelNode left = this.peek(1);
        boolean correlate = variablesSet.size() == 1;
        RexLiteral postCondition = this.literal(true);
        if (correlate) {
            CorrelationId id = (CorrelationId)Iterables.getOnlyElement(variablesSet);
            if (!RelOptUtil.notContainsCorrelation((RelNode)left, (CorrelationId)id, (Litmus)Litmus.IGNORE)) {
                throw new IllegalArgumentException("variable " + id + " must not be used by left input to correlation");
            }
            switch (joinType) {
                case LEFT: 
                case SEMI: 
                case ANTI: {
                    this.filter(new RexNode[]{(RexNode)condition.accept((RexVisitor)new Shifter(left, id, right))});
                    right = this.peek(0);
                    break;
                }
                case INNER: {
                    postCondition = condition;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Correlated " + joinType + " join is not supported");
                }
            }
            ImmutableBitSet requiredColumns = RelOptUtil.correlationColumns((CorrelationId)id, (RelNode)right);
            ImmutableList leftFields = this.fields(2, 0);
            ArrayList<RexNode> requiredFields = new ArrayList<RexNode>();
            for (int i = 0; i < leftFields.size(); ++i) {
                if (!requiredColumns.get(i)) continue;
                requiredFields.add((RexNode)leftFields.get(i));
            }
            this.correlate(joinType, id, requiredFields);
            this.filter(new RexNode[]{postCondition});
        } else {
            assert (variablesSet.isEmpty());
            super.join(joinType, condition, variablesSet);
        }
        return this;
    }

    private class Shifter
    extends RexShuttle {
        private final RelNode left;
        private final CorrelationId id;
        private final RelNode right;

        Shifter(RelNode left, CorrelationId id, RelNode right) {
            this.left = left;
            this.id = id;
            this.right = right;
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            RelDataType leftRowType = this.left.getRowType();
            RexBuilder rexBuilder = HiveRelBuilder.this.getRexBuilder();
            int leftCount = leftRowType.getFieldCount();
            if (inputRef.getIndex() < leftCount) {
                RexNode v = rexBuilder.makeCorrel(leftRowType, this.id);
                return rexBuilder.makeFieldAccess(v, inputRef.getIndex());
            }
            return rexBuilder.makeInputRef(this.right, inputRef.getIndex() - leftCount);
        }
    }
}

