/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.vector;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.FileMetadataCache;
import org.apache.hadoop.hive.common.io.encoded.MemoryBufferOrBuffers;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapCacheAwareFs;
import org.apache.hadoop.hive.llap.LlapHiveUtils;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.BucketIdentifier;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.io.RowPositionAwareVectorizedRecordReader;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.hive.ql.io.parquet.ParquetRecordReaderBase;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.hive.ql.io.parquet.vector.ParquetFooterInputFromCache;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedColumnReader;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedDummyColumnReader;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedListColumnReader;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedMapColumnReader;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedPrimitiveColumnReader;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedStructColumnReader;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.parquet.ParquetRuntimeException;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopStreams;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.InvalidSchemaException;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedParquetRecordReader
extends ParquetRecordReaderBase
implements RecordReader<NullWritable, VectorizedRowBatch>,
RowPositionAwareVectorizedRecordReader {
    public static final Logger LOG = LoggerFactory.getLogger(VectorizedParquetRecordReader.class);
    private List<Integer> colsToInclude;
    protected MessageType fileSchema;
    protected MessageType requestedSchema;
    private List<String> columnNamesList;
    private List<TypeInfo> columnTypesList;
    private VectorizedRowBatchCtx rbCtx;
    private Object[] partitionValues;
    private boolean addPartitionCols = true;
    private Path cacheFsPath;
    private static final int MAP_DEFINITION_LEVEL_MAX = 3;
    private VectorizedColumnReader[] columnReaders;
    private long rowsReturned = 0L;
    private long totalCountLoadedSoFar = 0L;
    protected long totalRowCount = 0L;
    private ZoneId writerTimezone;
    private final BucketIdentifier bucketIdentifier;
    private int lastReturnedRowCount = -1;
    private long currentRowNumInRowGroup = -1L;
    private int currentRowGroupIndex = -1;
    private Map<Integer, Long> rowGroupNumToRowPos = new HashMap<Integer, Long>();
    private Object cacheKey = null;
    private CacheTag cacheTag = null;
    private FileMetadataCache metadataCache;
    private DataCache cache;
    private Configuration cacheConf;

    public VectorizedParquetRecordReader(InputSplit oldInputSplit, JobConf conf) throws IOException {
        this(oldInputSplit, conf, null, null, null);
    }

    public VectorizedParquetRecordReader(InputSplit oldInputSplit, JobConf conf, FileMetadataCache metadataCache, DataCache dataCache, Configuration cacheConf, ParquetMetadata parquetMetadata) throws IOException {
        super(conf, oldInputSplit);
        try {
            this.metadataCache = metadataCache;
            this.cache = dataCache;
            this.cacheConf = cacheConf;
            if (metadataCache != null) {
                this.cacheKey = SyntheticFileId.fromJobConf(conf);
                if (this.cacheKey == null) {
                    this.cacheKey = LlapHiveUtils.createFileIdUsingFS(this.filePath.getFileSystem((Configuration)conf), this.filePath, cacheConf);
                }
                if (this.cacheKey != null) {
                    this.cacheTag = VectorizedParquetRecordReader.cacheTagOfParquetFile(this.filePath, cacheConf, conf);
                    if (this.cacheKey instanceof Long && HiveConf.getBoolVar((Configuration)cacheConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_USE_FILEID_PATH)) {
                        this.filePath = HdfsUtils.getFileIdPath(this.filePath, (Long)this.cacheKey);
                    }
                }
            }
            this.setupMetadataAndParquetSplit(conf, parquetMetadata);
            this.colsToInclude = ColumnProjectionUtils.getReadColumnIDs((Configuration)conf);
            this.rbCtx = Utilities.getVectorizedRowBatchCtx((Configuration)this.jobConf);
            if (this.parquetInputSplit != null) {
                this.initialize(this.parquetInputSplit, conf);
            }
            this.initPartitionValues(this.fileSplit, conf);
            this.bucketIdentifier = BucketIdentifier.from((Configuration)conf, this.filePath);
        }
        catch (Throwable e) {
            LOG.error("Failed to create the vectorized reader due to exception " + e);
            throw new RuntimeException(e);
        }
    }

    public VectorizedParquetRecordReader(InputSplit oldInputSplit, JobConf conf, FileMetadataCache metadataCache, DataCache dataCache, Configuration cacheConf) throws IOException {
        this(oldInputSplit, conf, metadataCache, dataCache, cacheConf, null);
    }

    private void initPartitionValues(FileSplit fileSplit, JobConf conf) throws IOException {
        int partitionColumnCount = this.rbCtx.getPartitionColumnCount();
        if (partitionColumnCount > 0) {
            this.partitionValues = new Object[partitionColumnCount];
            VectorizedRowBatchCtx.getPartitionValues(this.rbCtx, (Configuration)conf, fileSplit, this.partitionValues);
        } else {
            this.partitionValues = null;
        }
    }

    @Override
    protected ParquetMetadata getParquetMetadata(Path path, JobConf conf) throws IOException {
        return this.readSplitFooter(conf, this.filePath, this.cacheKey, ParquetMetadataConverter.NO_FILTER, this.cacheTag);
    }

    public void initialize(ParquetInputSplit split, JobConf configuration) throws IOException, InterruptedException, HiveException {
        boolean indexAccess = configuration.getBoolean("parquet.column.index.access", false);
        long[] rowGroupOffsets = split.getRowGroupOffsets();
        String columnNames = configuration.get("columns");
        this.columnNamesList = DataWritableReadSupport.getColumnNames(columnNames);
        String columnTypes = configuration.get("columns.types");
        this.columnTypesList = DataWritableReadSupport.getColumnTypes(columnTypes);
        HashSet<Long> offsets = new HashSet<Long>();
        for (long offset : rowGroupOffsets) {
            offsets.add(offset);
        }
        ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
        long allRowsInFile = 0L;
        int blockIndex = 0;
        for (BlockMetaData block : this.parquetMetadata.getBlocks()) {
            if (offsets.contains(block.getStartingPos())) {
                this.rowGroupNumToRowPos.put(blockIndex++, allRowsInFile);
                blocks.add(block);
            }
            allRowsInFile += block.getRowCount();
        }
        if (blocks.size() != rowGroupOffsets.length) {
            Object foundRowGroupOffsets = new long[this.parquetMetadata.getBlocks().size()];
            for (int i = 0; i < ((Object)foundRowGroupOffsets).length; ++i) {
                foundRowGroupOffsets[i] = ((BlockMetaData)this.parquetMetadata.getBlocks().get(i)).getStartingPos();
            }
            throw new IllegalStateException("All the offsets listed in the split should be found in the file. expected: " + Arrays.toString(rowGroupOffsets) + " found: " + blocks + " out of: " + Arrays.toString((long[])foundRowGroupOffsets) + " in range " + split.getStart() + ", " + split.getEnd());
        }
        for (BlockMetaData block : blocks) {
            this.totalRowCount += block.getRowCount();
        }
        this.fileSchema = this.parquetMetadata.getFileMetaData().getSchema();
        this.writerTimezone = DataWritableReadSupport.getWriterTimeZoneId(this.parquetMetadata.getFileMetaData().getKeyValueMetaData());
        this.colsToInclude = ColumnProjectionUtils.getReadColumnIDs((Configuration)configuration);
        this.requestedSchema = DataWritableReadSupport.getRequestedSchema(indexAccess, this.columnNamesList, this.columnTypesList, this.fileSchema, (Configuration)configuration);
        Path path = this.wrapPathForCache(this.filePath, this.cacheKey, configuration, blocks, this.cacheTag);
        this.reader = new ParquetFileReader((Configuration)configuration, this.parquetMetadata.getFileMetaData(), path, blocks, this.requestedSchema.getColumns());
    }

    private Path wrapPathForCache(Path path, Object fileKey, JobConf configuration, List<BlockMetaData> blocks, CacheTag tag) throws IOException {
        if (fileKey == null || this.cache == null) {
            return path;
        }
        HashSet<ColumnPath> includedCols = new HashSet<ColumnPath>();
        for (ColumnDescriptor col : this.requestedSchema.getColumns()) {
            includedCols.add(ColumnPath.get((String[])col.getPath()));
        }
        TreeMap<Long, Long> chunkIndex = new TreeMap<Long, Long>();
        for (BlockMetaData block : blocks) {
            for (ColumnChunkMetaData mc : block.getColumns()) {
                if (!includedCols.contains(mc.getPath())) continue;
                chunkIndex.put(mc.getStartingPos(), mc.getStartingPos() + mc.getTotalSize());
            }
        }
        configuration.set("fs.llapcache.impl", LlapCacheAwareFs.class.getCanonicalName());
        this.cacheFsPath = path = LlapCacheAwareFs.registerFile(this.cache, path, fileKey, chunkIndex, (Configuration)configuration, tag);
        return path;
    }

    private ParquetMetadata readSplitFooter(JobConf configuration, Path file, Object cacheKey, ParquetMetadataConverter.MetadataFilter filter, CacheTag tag) throws IOException {
        if (cacheKey == null || this.metadataCache == null) {
            FileSystem fs = file.getFileSystem((Configuration)configuration);
            FileStatus stat = fs.getFileStatus(file);
            return this.readFooterFromFile(file, fs, stat, filter);
        }
        MemoryBufferOrBuffers footerData = LlapProxy.getIo().getParquetFooterBuffersFromCache(file, configuration, cacheKey);
        return ParquetFileReader.readFooter((InputFile)new ParquetFooterInputFromCache(footerData), (ParquetMetadataConverter.MetadataFilter)filter);
    }

    private ParquetMetadata readFooterFromFile(final Path file, final FileSystem fs, final FileStatus stat, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        InputFile inputFile = new InputFile(){

            public SeekableInputStream newStream() throws IOException {
                return HadoopStreams.wrap((FSDataInputStream)fs.open(file));
            }

            public long getLength() {
                return stat.getLen();
            }
        };
        return ParquetFileReader.readFooter((InputFile)inputFile, (ParquetMetadataConverter.MetadataFilter)filter);
    }

    public static CacheTag cacheTagOfParquetFile(Path path, Configuration cacheConf, JobConf jobConf) {
        MapWork mapWork = LlapHiveUtils.findMapWork(jobConf);
        if (!HiveConf.getBoolVar((Configuration)cacheConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TRACK_CACHE_USAGE) || mapWork == null) {
            return null;
        }
        PartitionDesc partitionDesc = LlapHiveUtils.partitionDescForPath(path, mapWork.getPathToPartitionInfo());
        return LlapHiveUtils.getDbAndTableNameForMetrics(path, true, partitionDesc);
    }

    public boolean next(NullWritable nullWritable, VectorizedRowBatch vectorizedRowBatch) throws IOException {
        boolean hasMore = this.nextBatch(vectorizedRowBatch);
        if (this.bucketIdentifier != null) {
            this.rbCtx.setBucketAndWriteIdOf(vectorizedRowBatch, this.bucketIdentifier);
        }
        return hasMore;
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public VectorizedRowBatch createValue() {
        return this.rbCtx.createVectorizedRowBatch();
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public void close() throws IOException {
        if (this.cacheFsPath != null) {
            LlapCacheAwareFs.unregisterFile(this.cacheFsPath);
        }
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public float getProgress() throws IOException {
        return 0.0f;
    }

    @Override
    public long getRowNumber() throws IOException {
        return this.rowGroupNumToRowPos.get(this.currentRowGroupIndex) + this.currentRowNumInRowGroup;
    }

    private boolean nextBatch(VectorizedRowBatch columnarBatch) throws IOException {
        this.currentRowNumInRowGroup += (long)this.lastReturnedRowCount;
        VectorizedBatchUtil.resetNonPartitionColumns(columnarBatch);
        if (this.rowsReturned >= this.totalRowCount) {
            return false;
        }
        if (this.addPartitionCols) {
            if (this.partitionValues != null) {
                this.rbCtx.addPartitionColsToBatch(columnarBatch, this.partitionValues);
            }
            this.addPartitionCols = false;
        }
        this.checkEndOfRowGroup();
        int num = (int)Math.min(1024L, this.totalCountLoadedSoFar - this.rowsReturned);
        if (this.colsToInclude.size() > 0) {
            for (int i = 0; i < this.columnReaders.length; ++i) {
                if (this.columnReaders[i] == null) continue;
                columnarBatch.cols[this.colsToInclude.get((int)i).intValue()].isRepeating = true;
                this.columnReaders[i].readBatch(num, columnarBatch.cols[this.colsToInclude.get(i)], this.columnTypesList.get(this.colsToInclude.get(i)));
            }
        }
        this.lastReturnedRowCount = num;
        this.rowsReturned += (long)num;
        columnarBatch.size = num;
        return true;
    }

    private void checkEndOfRowGroup() throws IOException {
        if (this.rowsReturned != this.totalCountLoadedSoFar) {
            return;
        }
        PageReadStore pages = this.reader.readNextRowGroup();
        if (pages == null) {
            throw new IOException("expecting more rows but reached last block. Read " + this.rowsReturned + " out of " + this.totalRowCount);
        }
        List columns = this.requestedSchema.getColumns();
        List types = this.requestedSchema.getFields();
        this.columnReaders = new VectorizedColumnReader[columns.size()];
        if (!ColumnProjectionUtils.isReadAllColumns((Configuration)this.jobConf)) {
            if (!this.colsToInclude.isEmpty()) {
                for (int i = 0; i < types.size(); ++i) {
                    this.columnReaders[i] = this.buildVectorizedParquetReader(this.columnTypesList.get(this.colsToInclude.get(i)), (Type)types.get(i), pages, this.requestedSchema.getColumns(), this.skipTimestampConversion, this.writerTimezone, this.skipProlepticConversion, this.legacyConversionEnabled, 0);
                }
            }
        } else {
            for (int i = 0; i < types.size(); ++i) {
                this.columnReaders[i] = this.buildVectorizedParquetReader(this.columnTypesList.get(i), (Type)types.get(i), pages, this.requestedSchema.getColumns(), this.skipTimestampConversion, this.writerTimezone, this.skipProlepticConversion, this.legacyConversionEnabled, 0);
            }
        }
        this.currentRowNumInRowGroup = 0L;
        ++this.currentRowGroupIndex;
        this.totalCountLoadedSoFar += pages.getRowCount();
    }

    private List<ColumnDescriptor> getAllColumnDescriptorByType(int depth, Type type, List<ColumnDescriptor> columns) throws ParquetRuntimeException {
        ArrayList<ColumnDescriptor> res = new ArrayList<ColumnDescriptor>();
        for (ColumnDescriptor descriptor : columns) {
            if (depth >= descriptor.getPath().length) {
                throw new InvalidSchemaException("Corrupted Parquet schema");
            }
            if (!type.getName().equals(descriptor.getPath()[depth])) continue;
            res.add(descriptor);
        }
        return res;
    }

    private PrimitiveType getElementType(Type type) {
        if (type.isPrimitive()) {
            return type.asPrimitiveType();
        }
        if (type.asGroupType().getFields().size() > 1) {
            throw new RuntimeException("Current Parquet Vectorization reader doesn't support nested type");
        }
        Type childType = (Type)type.asGroupType().getFields().get(0);
        if (childType.isPrimitive()) {
            return childType.asPrimitiveType();
        }
        return ((Type)childType.asGroupType().getFields().get(0)).asPrimitiveType();
    }

    private VectorizedColumnReader buildVectorizedParquetReader(TypeInfo typeInfo, Type type, PageReadStore pages, List<ColumnDescriptor> columnDescriptors, boolean skipTimestampConversion, ZoneId writerTimezone, boolean skipProlepticConversion, boolean legacyConversionEnabled, int depth) throws IOException {
        List<ColumnDescriptor> descriptors = this.getAllColumnDescriptorByType(depth, type, columnDescriptors);
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                if (columnDescriptors == null || columnDescriptors.isEmpty()) {
                    throw new RuntimeException("Failed to find related Parquet column descriptor with type " + type);
                }
                if (this.fileSchema.getColumns().contains(descriptors.get(0))) {
                    return new VectorizedPrimitiveColumnReader(descriptors.get(0), pages.getPageReader(descriptors.get(0)), skipTimestampConversion, writerTimezone, skipProlepticConversion, legacyConversionEnabled, type, typeInfo);
                }
                return new VectorizedDummyColumnReader();
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                ArrayList<VectorizedColumnReader> fieldReaders = new ArrayList<VectorizedColumnReader>();
                List fieldTypes = structTypeInfo.getAllStructFieldTypeInfos();
                List types = type.asGroupType().getFields();
                for (int i = 0; i < fieldTypes.size(); ++i) {
                    VectorizedColumnReader r = this.buildVectorizedParquetReader((TypeInfo)fieldTypes.get(i), (Type)types.get(i), pages, descriptors, skipTimestampConversion, writerTimezone, skipProlepticConversion, legacyConversionEnabled, depth + 1);
                    if (r == null) {
                        throw new RuntimeException("Fail to build Parquet vectorized reader based on Hive type " + ((TypeInfo)fieldTypes.get(i)).getTypeName() + " and Parquet type" + ((Type)types.get(i)).toString());
                    }
                    fieldReaders.add(r);
                }
                return new VectorizedStructColumnReader(fieldReaders);
            }
            case LIST: {
                this.checkListColumnSupport(((ListTypeInfo)typeInfo).getListElementTypeInfo());
                if (columnDescriptors == null || columnDescriptors.isEmpty()) {
                    throw new RuntimeException("Failed to find related Parquet column descriptor with type " + type);
                }
                return new VectorizedListColumnReader(descriptors.get(0), pages.getPageReader(descriptors.get(0)), skipTimestampConversion, writerTimezone, skipProlepticConversion, legacyConversionEnabled, (Type)this.getElementType(type), typeInfo);
            }
            case MAP: {
                if (columnDescriptors == null || columnDescriptors.isEmpty()) {
                    throw new RuntimeException("Failed to find related Parquet column descriptor with type " + type);
                }
                int nestGroup = 0;
                GroupType groupType = type.asGroupType();
                while (groupType.getFieldCount() < 2) {
                    if (nestGroup > 3) {
                        throw new RuntimeException("More than 3 level is found in Map definition, Failed to get the field types for Map with type " + type);
                    }
                    groupType = ((Type)groupType.getFields().get(0)).asGroupType();
                    ++nestGroup;
                }
                List kvTypes = groupType.getFields();
                VectorizedListColumnReader keyListColumnReader = new VectorizedListColumnReader(descriptors.get(0), pages.getPageReader(descriptors.get(0)), skipTimestampConversion, writerTimezone, skipProlepticConversion, legacyConversionEnabled, (Type)kvTypes.get(0), typeInfo);
                VectorizedListColumnReader valueListColumnReader = new VectorizedListColumnReader(descriptors.get(1), pages.getPageReader(descriptors.get(1)), skipTimestampConversion, writerTimezone, skipProlepticConversion, legacyConversionEnabled, (Type)kvTypes.get(1), typeInfo);
                return new VectorizedMapColumnReader(keyListColumnReader, valueListColumnReader);
            }
        }
        throw new RuntimeException("Unsupported category " + typeInfo.getCategory().name());
    }

    private void checkListColumnSupport(TypeInfo elementType) {
        if (elementType instanceof PrimitiveTypeInfo) {
            switch (((PrimitiveTypeInfo)elementType).getPrimitiveCategory()) {
                case INTERVAL_DAY_TIME: 
                case TIMESTAMP: {
                    throw new RuntimeException("Unsupported primitive type used in list:: " + elementType);
                }
            }
        } else {
            throw new RuntimeException("Unsupported type used in list:" + elementType);
        }
    }
}

