/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.ql.io.BucketizedHiveInputSplit;
import org.apache.hadoop.hive.ql.io.BucketizedHiveRecordReader;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketizedHiveInputFormat<K extends WritableComparable, V extends Writable>
extends HiveInputFormat<K, V> {
    public static final Logger LOG = LoggerFactory.getLogger(BucketizedHiveInputFormat.class);

    @Override
    public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        BucketizedHiveInputSplit hsplit = (BucketizedHiveInputSplit)split;
        String inputFormatClassName = null;
        Class inputFormatClass = null;
        try {
            inputFormatClassName = hsplit.inputFormatClassName();
            inputFormatClass = job.getClassByName(inputFormatClassName);
        }
        catch (Exception e) {
            throw new IOException("cannot find class " + inputFormatClassName);
        }
        this.pushProjectionsAndFiltersAndAsOf(job, hsplit.getPath());
        InputFormat<WritableComparable, Writable> inputFormat = BucketizedHiveInputFormat.getInputFormatFromCache(inputFormatClass, job);
        BucketizedHiveRecordReader rr = new BucketizedHiveRecordReader(inputFormat, hsplit, job, reporter);
        rr.initIOContext(hsplit, job, inputFormatClass);
        return rr;
    }

    protected FileStatus[] listStatus(JobConf job, Path dir) throws IOException {
        ArrayList result = new ArrayList();
        ArrayList<IOException> errors = new ArrayList<IOException>();
        FileSystem fs = dir.getFileSystem((Configuration)job);
        FileStatus[] matches = fs.globStatus(dir, FileUtils.HIDDEN_FILES_PATH_FILTER);
        if (matches == null) {
            errors.add(new IOException("Input path does not exist: " + dir));
        } else if (matches.length == 0) {
            errors.add(new IOException("Input Pattern " + dir + " matches 0 files"));
        } else {
            for (FileStatus globStat : matches) {
                FileUtils.listStatusRecursively((FileSystem)fs, (FileStatus)globStat, result);
            }
        }
        if (!errors.isEmpty()) {
            throw new InvalidInputException(errors);
        }
        LOG.debug("Matches for " + dir + ": " + result);
        LOG.info("Total input paths to process : " + result.size() + " from dir " + dir);
        return result.toArray(new FileStatus[result.size()]);
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        this.init(job);
        Path[] dirs = this.getInputPaths(job);
        JobConf newjob = new JobConf((Configuration)job);
        ArrayList<InputSplit> result = new ArrayList<InputSplit>();
        int numOrigSplits = 0;
        Object currentDir = null;
        for (Path dir : dirs) {
            PartitionDesc part = BucketizedHiveInputFormat.getPartitionDescFromPath(this.pathToPartitionInfo, dir);
            Class<? extends InputFormat> inputFormatClass = part.getInputFileFormatClass();
            InputFormat<WritableComparable, Writable> inputFormat = BucketizedHiveInputFormat.getInputFormatFromCache(inputFormatClass, job);
            newjob.setInputFormat(inputFormat.getClass());
            ValidWriteIdList mmIds = null;
            if (part.getTableDesc() != null) {
                mmIds = this.getMmValidWriteIds(newjob, part.getTableDesc(), null);
            }
            ArrayList finalDirs = null;
            ArrayList<Path> dirsWithMmOriginals = null;
            if (mmIds == null) {
                finalDirs = Lists.newArrayList((Object[])new Path[]{dir});
            } else {
                finalDirs = new ArrayList();
                dirsWithMmOriginals = new ArrayList<Path>();
                BucketizedHiveInputFormat.processPathsForMmRead(Lists.newArrayList((Object[])new Path[]{dir}), (Configuration)newjob, mmIds, finalDirs, dirsWithMmOriginals);
            }
            if (finalDirs.isEmpty() && (dirsWithMmOriginals == null || dirsWithMmOriginals.isEmpty())) continue;
            for (Path finalDir : finalDirs) {
                FileStatus[] listStatus;
                for (FileStatus status : listStatus = this.listStatus(newjob, finalDir)) {
                    numOrigSplits = this.addBHISplit(status, inputFormat, inputFormatClass, numOrigSplits, newjob, result);
                }
            }
            if (dirsWithMmOriginals == null) continue;
            for (Path originalsDir : dirsWithMmOriginals) {
                FileStatus[] listStatus;
                FileSystem fs = originalsDir.getFileSystem((Configuration)job);
                for (FileStatus status : listStatus = fs.listStatus(dir, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                    if (status.isDirectory()) continue;
                    numOrigSplits = this.addBHISplit(status, inputFormat, inputFormatClass, numOrigSplits, newjob, result);
                }
            }
        }
        LOG.info(result.size() + " bucketized splits generated from " + numOrigSplits + " original splits.");
        return result.toArray(new BucketizedHiveInputSplit[result.size()]);
    }

    private int addBHISplit(FileStatus status, InputFormat inputFormat, Class inputFormatClass, int numOrigSplits, JobConf newjob, ArrayList<InputSplit> result) throws IOException {
        LOG.info("block size: " + status.getBlockSize());
        LOG.info("file length: " + status.getLen());
        FileInputFormat.setInputPaths((JobConf)newjob, (Path[])new Path[]{status.getPath()});
        InputSplit[] iss = inputFormat.getSplits(newjob, 0);
        if (iss != null && iss.length > 0) {
            numOrigSplits += iss.length;
            result.add(new BucketizedHiveInputSplit(iss, inputFormatClass.getName()));
        }
        return numOrigSplits;
    }
}

