/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorRowNumber
extends VectorPTFEvaluatorBase {
    private long rowNumber;

    public VectorPTFEvaluatorRowNumber(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        int size = batch.size;
        LongColumnVector longColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        long[] vector = longColVector.vector;
        for (int i = 0; i < size; ++i) {
            ++this.rowNumber;
        }
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public boolean isGroupResultNull() {
        return false;
    }

    @Override
    public Object getGroupResult() {
        return this.rowNumber;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.LONG;
    }

    @Override
    public void resetEvaluator() {
        this.rowNumber = 1L;
    }
}

