/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import org.apache.hadoop.hive.serde2.WriteBuffers;

public class VectorMapJoinFastBytesHashKeyRef {
    public static boolean equalKey(long refWord, byte[] keyBytes, int keyStart, int keyLength, WriteBuffers writeBuffers, WriteBuffers.Position readPos) {
        boolean isKeyLengthSmall;
        long absoluteOffset = KeyRef.getAbsoluteOffset(refWord);
        writeBuffers.setReadPoint(absoluteOffset, readPos);
        int actualKeyLength = KeyRef.getSmallKeyLength(refWord);
        boolean bl = isKeyLengthSmall = actualKeyLength != 255;
        if (!isKeyLengthSmall) {
            actualKeyLength = writeBuffers.readVInt(readPos);
        }
        if (actualKeyLength != keyLength) {
            return false;
        }
        return writeBuffers.isEqual(keyBytes, keyStart, readPos, keyLength);
    }

    public static int calculateHashCode(long refWord, WriteBuffers writeBuffers, WriteBuffers.Position readPos) {
        boolean isKeyLengthSmall;
        long absoluteOffset = KeyRef.getAbsoluteOffset(refWord);
        int actualKeyLength = KeyRef.getSmallKeyLength(refWord);
        boolean bl = isKeyLengthSmall = actualKeyLength != 255;
        if (!isKeyLengthSmall) {
            writeBuffers.setReadPoint(absoluteOffset, readPos);
            actualKeyLength = writeBuffers.readVInt(readPos);
            return writeBuffers.hashCode(actualKeyLength, readPos);
        }
        long keyAbsoluteOffset = absoluteOffset;
        return writeBuffers.unsafeHashCode(keyAbsoluteOffset, actualKeyLength);
    }

    public static long extractPartialHashCode(long hashCode) {
        return hashCode >>> 17 & 0x7FFFL;
    }

    public static long getPartialHashCodeFromRefWord(long refWord) {
        return KeyRef.getPartialHashCode(refWord);
    }

    public static final class KeyRef {
        public static long getPartialHashCode(long refWord) {
            return refWord & 0x7FFFL;
        }

        public static long getAbsoluteOffset(long refWord) {
            return (refWord & 0x3FFFFFFFFF8000L) >> 15;
        }

        public static int getSmallKeyLength(long refWord) {
            return (int)((refWord & 0x3FC0000000000000L) >> 54);
        }

        public static boolean getIsSingleFlag(long refWord) {
            return (refWord & 0x4000000000000000L) != 0L;
        }

        public static boolean getIsInvalidFlag(long refWord) {
            return (refWord & Long.MIN_VALUE) != 0L;
        }

        public static final class PartialHashCode {
            public static final int bitLength = 15;
            public static final long allBitsOn = 32767L;
            public static final long bitMask = 32767L;
            public static final int intChooseBitShift = 17;
        }

        public static final class AbsoluteOffset {
            public static final int bitLength = 39;
            public static final int byteLength = 5;
            public static final long allBitsOn = 0x7FFFFFFFFFL;
            public static final int bitShift = 15;
            public static final long bitMask = 18014398509449216L;
            public static final long maxSize = 0x2000000000L;
        }

        public static final class SmallKeyLength {
            public static final int bitLength = 8;
            public static final int allBitsOn = 255;
            public static final int threshold = 255;
            public static final int bitShift = 54;
            public static final long bitMask = 4593671619917905920L;
            public static final long allBitsOnBitShifted = 4593671619917905920L;
        }

        public static final class IsSingleFlag {
            public static final int bitShift = 62;
            public static final long flagOnMask = 0x4000000000000000L;
            public static final long flagOffMask = -4611686018427387905L;
        }

        public static final class IsInvalidFlag {
            public static final int bitShift = 63;
            public static final long flagOnMask = Long.MIN_VALUE;
        }
    }
}

