/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprLongScalarDoubleColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected final long arg2Scalar;

    public IfExprLongScalarDoubleColumn(int arg1Column, long arg2Scalar, int arg3Column, int outputColumnNum) {
        super(arg1Column, arg3Column, outputColumnNum);
        this.arg2Scalar = arg2Scalar;
    }

    public IfExprLongScalarDoubleColumn() {
        this.arg2Scalar = 0L;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.inputColumnNum[0]];
        DoubleColumnVector arg3ColVector = (DoubleColumnVector)batch.cols[this.inputColumnNum[1]];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        long[] vector1 = arg1ColVector.vector;
        double[] vector3 = arg3ColVector.vector;
        double[] outputVector = outputColVector.vector;
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                outputColVector.fill((double)this.arg2Scalar);
            } else {
                arg3ColVector.copySelected(batch.selectedInUse, sel, n, (ColumnVector)outputColVector);
            }
            return;
        }
        arg3ColVector.flatten(batch.selectedInUse, sel, n);
        outputColVector.noNulls = false;
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = vector1[i] == 1L ? (double)this.arg2Scalar : vector3[i];
                    outputIsNull[i] = vector1[i] == 1L ? false : arg3ColVector.isNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] == 1L ? (double)this.arg2Scalar : vector3[i];
                    outputIsNull[i] = vector1[i] == 1L ? false : arg3ColVector.isNull[i];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? (double)this.arg2Scalar : vector3[i];
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? false : arg3ColVector.isNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? (double)this.arg2Scalar : vector3[i];
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? false : arg3ColVector.isNull[i];
            }
        }
        arg3ColVector.unFlatten();
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", val " + this.arg2Scalar + ", " + this.getColumnParamString(2, this.inputColumnNum[1]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("double")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

