/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprLongColumnDoubleScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected final double arg3Scalar;

    public IfExprLongColumnDoubleScalar(int arg1Column, int arg2Column, double arg3Scalar, int outputColumnNum) {
        super(arg1Column, arg2Column, outputColumnNum);
        this.arg3Scalar = arg3Scalar;
    }

    public IfExprLongColumnDoubleScalar() {
        this.arg3Scalar = 0.0;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.inputColumnNum[0]];
        LongColumnVector arg2ColVector = (LongColumnVector)batch.cols[this.inputColumnNum[1]];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        long[] vector1 = arg1ColVector.vector;
        long[] vector2 = arg2ColVector.vector;
        double[] outputVector = outputColVector.vector;
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                arg2ColVector.copySelected(batch.selectedInUse, sel, n, outputColVector);
            } else {
                outputColVector.fill(this.arg3Scalar);
            }
            return;
        }
        arg2ColVector.flatten(batch.selectedInUse, sel, n);
        outputColVector.noNulls = false;
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = vector1[i] == 1L ? (double)vector2[i] : this.arg3Scalar;
                    outputIsNull[i] = vector1[i] == 1L ? arg2ColVector.isNull[i] : false;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] == 1L ? (double)vector2[i] : this.arg3Scalar;
                    outputIsNull[i] = vector1[i] == 1L ? arg2ColVector.isNull[i] : false;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? (double)vector2[i] : this.arg3Scalar;
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? (double)vector2[i] : this.arg3Scalar;
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : false;
            }
        }
        arg2ColVector.unFlatten();
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", " + this.getColumnParamString(1, this.inputColumnNum[1]) + ", val " + this.arg3Scalar;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("double")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

