/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorLimitDesc;

public class VectorLimitOperator
extends LimitOperator
implements VectorizationOperator {
    private static final long serialVersionUID = 1L;
    private VectorizationContext vContext;
    private VectorLimitDesc vectorDesc;

    @VisibleForTesting
    public VectorLimitOperator() {
    }

    public VectorLimitOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorLimitOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) {
        this(ctx);
        this.conf = (LimitDesc)conf;
        this.vContext = vContext;
        this.vectorDesc = (VectorLimitDesc)vectorDesc;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
    }

    @Override
    public VectorizationContext getInputVectorizationContext() {
        return this.vContext;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)row;
        AtomicInteger currentCountForAllTasks = this.getCurrentCount();
        if (this.currCount + batch.size <= this.offset) {
            this.currCount += batch.size;
        } else if (this.currCount >= this.offset + this.limit || currentCountForAllTasks.get() >= this.offset + this.limit) {
            this.LOG.debug("Limit reached: currCount: {}, currentCountForAllTasks: {}", (Object)this.currCount, (Object)currentCountForAllTasks.get());
            this.onLimitReached();
        } else {
            int skipSize = 0;
            if (this.currCount < this.offset) {
                skipSize = this.offset - this.currCount;
            }
            batch.size = Math.min(batch.size, this.offset + this.limit - this.currCount);
            int newBatchSize = batch.size - skipSize;
            if (!batch.selectedInUse) {
                batch.selectedInUse = true;
                for (int i = 0; i < newBatchSize; ++i) {
                    batch.selected[i] = skipSize + i;
                }
            } else {
                for (int i = 0; i < newBatchSize; ++i) {
                    batch.selected[i] = batch.selected[skipSize + i];
                }
            }
            this.currCount += batch.size;
            currentCountForAllTasks.set(currentCountForAllTasks.get() + batch.size);
            batch.size = newBatchSize;
            this.vectorForward(batch);
        }
    }

    @Override
    public VectorDesc getVectorDesc() {
        return this.vectorDesc;
    }
}

