/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.archive;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

final class AlterTableArchiveUtils {
    static final String ARCHIVE_NAME = "data.har";

    private AlterTableArchiveUtils() {
        throw new UnsupportedOperationException("ArchiveUtils should not be instantiated");
    }

    static String getOriginalLocation(Partition partition) {
        Map<String, String> params = partition.getParameters();
        return params.get("original_location");
    }

    static void setOriginalLocation(Partition partition, String loc) {
        Map<String, String> params = partition.getParameters();
        if (loc == null) {
            params.remove("original_location");
        } else {
            params.put("original_location", loc);
        }
    }

    static boolean partitionInCustomLocation(Table table, Partition partition) throws HiveException {
        String subdir = null;
        try {
            subdir = Warehouse.makePartName(table.getPartCols(), partition.getValues());
        }
        catch (MetaException e) {
            throw new HiveException("Unable to get partition's directory", (Throwable)e);
        }
        Path tableDir = table.getDataLocation();
        if (tableDir == null) {
            throw new HiveException("Table has no location set");
        }
        String standardLocation = new Path(tableDir, subdir).toString();
        if (ArchiveUtils.isArchived(partition)) {
            return !AlterTableArchiveUtils.getOriginalLocation(partition).equals(standardLocation);
        }
        return !partition.getLocation().equals(standardLocation);
    }

    static Path getInterMediateDir(Path dir, Configuration conf, HiveConf.ConfVars suffixConfig) {
        String intermediateDirSuffix = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)suffixConfig);
        return new Path(dir.getParent(), dir.getName() + intermediateDirSuffix);
    }

    static void deleteDir(Path dir, boolean shouldEnableCm, Configuration conf) throws HiveException {
        try {
            Warehouse wh = new Warehouse(conf);
            wh.deleteDir(dir, true, false, shouldEnableCm);
        }
        catch (MetaException e) {
            throw new HiveException((Throwable)e);
        }
    }

    static void setIsArchived(Partition partition, boolean state, int level) {
        Map<String, String> params = partition.getParameters();
        if (state) {
            params.put("is_archived", "true");
            params.put("archiving_level", Integer.toString(level));
        } else {
            params.remove("is_archived");
            params.remove("archiving_level");
        }
    }
}

