/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.show;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.formatting.MapBuilder;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.session.SessionState;

abstract class ShowPartitionsFormatter {
    ShowPartitionsFormatter() {
    }

    static ShowPartitionsFormatter getFormatter(HiveConf conf) {
        if (MetaDataFormatUtils.isJson(conf)) {
            return new JsonShowPartitionsFormatter();
        }
        return new TextShowPartitionsFormatter();
    }

    abstract void showTablePartitions(DataOutputStream var1, List<String> var2) throws HiveException;

    static class JsonShowPartitionsFormatter
    extends ShowPartitionsFormatter {
        JsonShowPartitionsFormatter() {
        }

        @Override
        void showTablePartitions(DataOutputStream out, List<String> partitions) throws HiveException {
            ArrayList<Map<String, Object>> partitionData = new ArrayList<Map<String, Object>>(partitions.size());
            for (String partition : partitions) {
                partitionData.add(this.makeOneTablePartition(partition));
            }
            ShowUtils.asJson(out, MapBuilder.create().put("partitions", partitionData).build());
        }

        private Map<String, Object> makeOneTablePartition(String partition) {
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            ArrayList<Object> names = new ArrayList<Object>();
            String[] stringArray = partition.split("/");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String part;
                String name = part = stringArray[i];
                String value = null;
                String[] keyValue = StringUtils.split((String)part, (String)"=", (int)2);
                if (keyValue != null) {
                    name = keyValue[0];
                    if (keyValue.length > 1) {
                        try {
                            value = URLDecoder.decode(keyValue[1], StandardCharsets.UTF_8.name());
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                }
                if (value != null) {
                    names.add(name + "='" + value + "'");
                } else {
                    names.add(name);
                }
                result.add(MapBuilder.create().put("columnName", name).put("columnValue", value).build());
            }
            return MapBuilder.create().put("name", StringUtils.join(names, (String)",")).put("values", result).build();
        }
    }

    static class TextShowPartitionsFormatter
    extends ShowPartitionsFormatter {
        TextShowPartitionsFormatter() {
        }

        @Override
        void showTablePartitions(DataOutputStream outStream, List<String> partitions) throws HiveException {
            try {
                for (String partition : partitions) {
                    SessionState ss = SessionState.get();
                    if (ss != null && ss.getConf() != null && !ss.getConf().getBoolVar(HiveConf.ConfVars.HIVE_DECODE_PARTITION_NAME)) {
                        outStream.write(partition.getBytes(StandardCharsets.UTF_8));
                    } else {
                        outStream.write(FileUtils.unescapePathName((String)partition).getBytes(StandardCharsets.UTF_8));
                    }
                    outStream.write(10);
                }
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        }
    }
}

