/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.drop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.partition.drop.AlterTableDropPartitionDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;

abstract class AbstractDropPartitionAnalyzer
extends AbstractAlterTableAnalyzer {
    AbstractDropPartitionAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        boolean ifExists;
        boolean canGroupExprs = ifExists = command.getFirstChildWithType(1050) != null || HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DROP_IGNORES_NON_EXISTENT);
        boolean mustPurge = command.getFirstChildWithType(274) != null;
        ReplicationSpec replicationSpec = new ReplicationSpec(command);
        Table table = null;
        try {
            table = this.getTable(tableName);
        }
        catch (SemanticException se) {
            if (replicationSpec.isInReplicationScope() && (se.getCause() instanceof InvalidTableException || se.getMessage().contains(ErrorMsg.INVALID_TABLE.getMsg()))) {
                return;
            }
            throw se;
        }
        this.validateAlterTableType(table, AlterTableType.DROPPARTITION, this.expectView());
        Map<Integer, List<ExprNodeGenericFuncDesc>> partitionSpecs = ParseUtils.getFullPartitionSpecs((CommonTree)command, table, (Configuration)this.conf, canGroupExprs);
        if (partitionSpecs.isEmpty()) {
            return;
        }
        ReadEntity re = new ReadEntity(table);
        re.noLockNeeded();
        this.inputs.add(re);
        boolean dropPartUseBase = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_DROP_PARTITION_USE_BASE) || HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED) && AcidUtils.isTransactionalTable(table);
        this.addTableDropPartsOutputs(table, partitionSpecs.values(), !ifExists, dropPartUseBase);
        AlterTableDropPartitionDesc desc = new AlterTableDropPartitionDesc(tableName, partitionSpecs, mustPurge, replicationSpec, !dropPartUseBase, table);
        if (desc.mayNeedWriteId()) {
            this.setAcidDdlDesc(desc);
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    protected abstract boolean expectView();

    private void addTableDropPartsOutputs(Table table, Collection<List<ExprNodeGenericFuncDesc>> partitionSpecs, boolean throwIfNonExistent, boolean dropPartUseBase) throws SemanticException {
        WriteEntity.WriteType writeType = dropPartUseBase ? WriteEntity.WriteType.DDL_EXCL_WRITE : WriteEntity.WriteType.DDL_EXCLUSIVE;
        for (List<ExprNodeGenericFuncDesc> specs : partitionSpecs) {
            for (ExprNodeGenericFuncDesc partitionSpec : specs) {
                ArrayList<Partition> parts = new ArrayList<Partition>();
                boolean hasUnknown = false;
                try {
                    hasUnknown = this.db.getPartitionsByExpr(table, partitionSpec, this.conf, parts);
                }
                catch (Exception e) {
                    throw new SemanticException("Error fetching partitions for " + partitionSpec.getExprString() + ", message: " + e.getMessage(), (Throwable)e);
                }
                if (hasUnknown) {
                    throw new SemanticException("Unexpected unknown partitions for " + partitionSpec.getExprString());
                }
                if (parts.isEmpty() && throwIfNonExistent) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partitionSpec.getExprString()));
                }
                for (Partition p : parts) {
                    this.outputs.add(new WriteEntity(p, writeType));
                }
            }
        }
    }
}

