/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.lock.show;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Show Locks", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ShowLocksDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String OLD_FORMAT_SCHEMA = "tab_name,mode#string:string";
    private static final String NEW_FORMAT_SCHEMA = "lockid,database,table,partition,lock_state,blocked_by,lock_type,transaction_id,last_heartbeat,acquired_at,user,hostname,agent_info#string:string:string:string:string:string:string:string:string:string:string:string:string";
    private final String resFile;
    private final String dbName;
    private final String tableName;
    private final Map<String, String> partSpec;
    private final boolean isExt;
    private final boolean isNewFormat;

    public ShowLocksDesc(Path resFile, String dbName, boolean isExt, boolean isNewFormat) {
        this.resFile = resFile.toString();
        this.dbName = dbName;
        this.tableName = null;
        this.partSpec = null;
        this.isExt = isExt;
        this.isNewFormat = isNewFormat;
    }

    public ShowLocksDesc(Path resFile, String tableName, Map<String, String> partSpec, boolean isExt, boolean isNewFormat) {
        this.resFile = resFile.toString();
        this.dbName = null;
        this.tableName = tableName;
        this.partSpec = partSpec;
        this.isExt = isExt;
        this.isNewFormat = isNewFormat;
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFile() {
        return this.resFile;
    }

    @Explain(displayName="dbName", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getDbName() {
        return this.dbName;
    }

    @Explain(displayName="table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName;
    }

    @Explain(displayName="partition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getPartSpec() {
        return this.partSpec;
    }

    public boolean isExt() {
        return this.isExt;
    }

    public boolean isNewFormat() {
        return this.isNewFormat;
    }

    public String getSchema() {
        return this.isNewFormat ? NEW_FORMAT_SCHEMA : OLD_FORMAT_SCHEMA;
    }
}

