/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hertzbeat.alert.service.SmsClient;
import org.apache.hertzbeat.alert.util.CryptoUtils;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.NoticeReceiver;
import org.apache.hertzbeat.common.entity.alerter.NoticeTemplate;
import org.apache.hertzbeat.common.entity.dto.sms.AwsSmsProperties;
import org.apache.hertzbeat.common.support.exception.SendMessageException;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsSmsClientImpl
implements SmsClient {
    private static final Logger log = LoggerFactory.getLogger(AwsSmsClientImpl.class);
    private static final String SERVICE = "sms-voice";
    private static final String MESSAGE_TEMPLATE = "Instance: %s, Priority: %s, Content: %s";
    private final String accessKey;
    private final String secretKey;
    private final String region;

    public AwsSmsClientImpl(AwsSmsProperties config) {
        if (config != null) {
            this.accessKey = config.getAccessKeyId();
            this.secretKey = config.getAccessKeySecret();
            this.region = config.getRegion();
        } else {
            this.accessKey = "";
            this.secretKey = "";
            this.region = "";
        }
    }

    @Override
    public void sendMessage(NoticeReceiver receiver, NoticeTemplate noticeTemplate, GroupAlert alert) {
        String instance = null;
        String priority = null;
        String content = null;
        if (alert.getCommonLabels() != null) {
            instance = alert.getCommonLabels().get("instance") == null ? alert.getGroupKey() : (String)alert.getCommonLabels().get("instance");
            priority = alert.getCommonLabels().get("priority") == null ? "unknown" : (String)alert.getCommonLabels().get("priority");
            content = (String)alert.getCommonAnnotations().get("summary");
            String string = content = content == null ? (String)alert.getCommonAnnotations().get("description") : content;
            if (content == null) {
                content = alert.getCommonAnnotations().values().stream().findFirst().orElse(null);
            }
        }
        this.send(receiver.getPhone(), this.createMessage(instance, priority, content));
    }

    private String createMessage(String instance, String priority, String content) {
        return String.format(MESSAGE_TEMPLATE, instance, priority, content);
    }

    private void send(String phoneNumber, String message) {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("MessageBody", message);
        payload.put("DestinationPhoneNumber", phoneNumber);
        payload.put("MessageType", "TRANSACTIONAL");
        Instant now = Instant.now();
        String amzDate = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").withZone(ZoneOffset.UTC).format(now);
        String endpoint = "https://sms-voice." + this.region + ".amazonaws.com";
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String payloadInString = new ObjectMapper().writeValueAsString(payload);
            URI requestUri = new URI(endpoint);
            HttpPost httpPost = this.createHttpPost(requestUri, amzDate, payloadInString);
            log.info("Sending AWS SMS request to {}", (Object)(requestUri + ",headers: " + Arrays.toString(httpPost.getAllHeaders())));
            this.executeRequest(httpClient, httpPost, phoneNumber);
        }
        catch (Exception e) {
            log.warn("Failed to send SMS: {}", (Object)e.getMessage());
            throw new SendMessageException(e.getMessage());
        }
    }

    private HttpPost createHttpPost(URI requestUri, String amzDate, String payloadInString) throws Exception {
        LinkedHashMap<String, Object> headers = new LinkedHashMap<String, Object>();
        headers.put("content-type", "application/x-amz-json-1.0");
        headers.put("host", "sms-voice." + this.region + ".amazonaws.com");
        headers.put("x-amz-date", amzDate);
        headers.put("x-amz-target", "PinpointSMSVoiceV2.SendTextMessage");
        AwsAuthenticationBuilder authBuilder = new AwsAuthenticationBuilder().credential(this.accessKey, this.secretKey).region(this.region);
        headers.forEach(authBuilder::header);
        String authorizationHeader = authBuilder.build(requestUri, "POST", SERVICE, payloadInString);
        HttpPost httpPost = new HttpPost(requestUri);
        httpPost.setHeader("Authorization", authorizationHeader);
        headers.forEach((arg_0, arg_1) -> ((HttpPost)httpPost).setHeader(arg_0, arg_1));
        httpPost.setEntity((HttpEntity)new StringEntity(payloadInString, ContentType.APPLICATION_JSON));
        return httpPost;
    }

    private void executeRequest(CloseableHttpClient httpClient, HttpPost httpPost, String phoneNumber) throws Exception {
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            int statusCode = response.getStatusLine().getStatusCode();
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("SMS response status: {}, body: {}", (Object)statusCode, (Object)responseBody);
            if (statusCode != 200) {
                throw new SendMessageException("HTTP request failed with status code: " + statusCode + ", response: " + responseBody);
            }
            JsonNode jsonResponse = JsonUtil.fromJson((String)responseBody);
            if (jsonResponse == null) {
                throw new SendMessageException(statusCode + ":" + responseBody);
            }
            JsonNode responseNode = jsonResponse.get("MessageId");
            if (responseNode == null) {
                throw new SendMessageException(statusCode + ":" + responseBody);
            }
            String messageId = responseNode.asText();
            log.info("Successfully sent SMS to phone: {}, messageId: {}", (Object)phoneNumber, (Object)messageId);
        }
    }

    @Override
    public String getType() {
        return "aws";
    }

    @Override
    public boolean checkConfig() {
        return !this.accessKey.isBlank() && !this.secretKey.isBlank() && !this.region.isBlank();
    }

    private static class AwsAuthenticationBuilder {
        private String accessKey;
        private String secretKey;
        private String region;
        private String service;
        private URI requestUri;
        private String method;
        private String payload;
        private final Map<String, String> headers = new LinkedHashMap<String, String>();

        private AwsAuthenticationBuilder() {
        }

        public AwsAuthenticationBuilder region(String region) {
            this.region = region;
            return this;
        }

        public AwsAuthenticationBuilder credential(String accessKey, String secretKey) {
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            return this;
        }

        public AwsAuthenticationBuilder header(String header, String value) {
            this.headers.put(header, value);
            return this;
        }

        public String build(URI requestUri, String method, String service, String payload) throws Exception {
            this.requestUri = requestUri;
            this.method = method;
            this.service = service;
            this.payload = payload;
            return "%s Credential=%s/%s, SignedHeaders=%s, Signature=%s".formatted(this.getAlgorithm(), this.accessKey, this.getCredentialScope(), this.getSignedHeaders(), this.getSignature());
        }

        private String getCredentialScope() {
            return this.getDateStamp() + "/" + this.region + "/" + this.service + "/aws4_request";
        }

        private String getSignedHeaders() {
            return String.join((CharSequence)";", this.headers.keySet());
        }

        private String getDateTime() {
            return this.headers.get("x-amz-date");
        }

        private String getDateStamp() {
            return this.getDateTime().substring(0, 8);
        }

        private String getSignature() {
            String canonicalRequest = this.getCanonicalRequest();
            String stringToSign = String.join((CharSequence)"\n", this.getAlgorithm(), this.getDateTime(), this.getCredentialScope(), CryptoUtils.sha256Hex(canonicalRequest));
            byte[] signingKey = this.getSignatureKey(this.secretKey, this.getDateStamp(), this.region, this.service);
            return CryptoUtils.hmacSha256Hex(signingKey, stringToSign);
        }

        private String getCanonicalRequest() {
            return String.join((CharSequence)"\n", this.method, this.requestUri.getPath().isEmpty() ? "/" : this.requestUri.getPath(), this.requestUri.getQuery() != null ? this.requestUri.getQuery() : "", this.getCanonicalHeaders(), this.getSignedHeaders(), CryptoUtils.sha256Hex(this.payload));
        }

        private String getCanonicalHeaders() {
            return this.headers.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.joining("\n")) + "\n";
        }

        private String getAlgorithm() {
            return "AWS4-HMAC-SHA256";
        }

        private byte[] getSignatureKey(String key, String dateStamp, String regionName, String serviceName) {
            byte[] secret = ("AWS4" + key).getBytes(StandardCharsets.UTF_8);
            byte[] date = CryptoUtils.hmac256(secret, dateStamp);
            byte[] region = CryptoUtils.hmac256(date, regionName);
            byte[] service = CryptoUtils.hmac256(region, serviceName);
            return CryptoUtils.hmac256(service, "aws4_request");
        }
    }
}

