/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp;

import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.context.McpAsyncRequestContext;
import org.springaicommunity.mcp.context.McpSyncRequestContext;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class McpPredicates {
    private static final Logger logger = LoggerFactory.getLogger(McpPredicates.class);
    private static final Pattern URI_VARIABLE_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    public static final Predicate<Method> isReactiveReturnType = method -> Mono.class.isAssignableFrom(method.getReturnType()) || Flux.class.isAssignableFrom(method.getReturnType()) || Publisher.class.isAssignableFrom(method.getReturnType());
    public static final Predicate<Method> isNotReactiveReturnType = method -> !Mono.class.isAssignableFrom(method.getReturnType()) && !Flux.class.isAssignableFrom(method.getReturnType()) && !Publisher.class.isAssignableFrom(method.getReturnType());

    public static boolean isUriTemplate(String uri) {
        return URI_VARIABLE_PATTERN.matcher(uri).find();
    }

    public static Predicate<Method> filterNonReactiveReturnTypeMethod() {
        return method -> {
            if (isReactiveReturnType.test((Method)method)) {
                return true;
            }
            logger.warn("ASYNC Providers don't support imperative (non-reactive) return types. Skipping method {} with non-reactive return type {}", method, method.getReturnType());
            return false;
        };
    }

    public static Predicate<Method> filterReactiveReturnTypeMethod() {
        return method -> {
            if (isNotReactiveReturnType.test((Method)method)) {
                return true;
            }
            logger.warn("SYNC Providers don't support reactive return types. Skipping method {} with reactive return type {}", method, method.getReturnType());
            return false;
        };
    }

    private static boolean hasBidirectionalParameters(Method method) {
        for (Class<?> paramType : method.getParameterTypes()) {
            if (!McpSyncRequestContext.class.isAssignableFrom(paramType) && !McpAsyncRequestContext.class.isAssignableFrom(paramType) && !McpSyncServerExchange.class.isAssignableFrom(paramType) && !McpAsyncServerExchange.class.isAssignableFrom(paramType)) continue;
            return true;
        }
        return false;
    }

    public static Predicate<Method> filterMethodWithBidirectionalParameters() {
        return method -> {
            if (!McpPredicates.hasBidirectionalParameters(method)) {
                return true;
            }
            logger.warn("Stateless servers doesn't support bidirectional parameters. Skipping method {} with bidirectional parameters", method);
            return false;
        };
    }
}

