/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Unsafe;
import io.questdb.std.str.AsciiCharSequence;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class Utf8String
implements Utf8Sequence {
    public static final Utf8String EMPTY = new Utf8String("");
    private final boolean ascii;
    private final AsciiCharSequence asciiCharSequence = new AsciiCharSequence();
    private final byte[] bytes;
    private final long zeroPaddedSixPrefix;

    public Utf8String(byte @NotNull [] bytes, boolean ascii) {
        this.bytes = bytes;
        this.ascii = ascii;
        this.zeroPaddedSixPrefix = Utf8s.zeroPaddedSixPrefix(this);
    }

    public Utf8String(@NotNull String str) {
        this.bytes = str.getBytes(StandardCharsets.UTF_8);
        this.ascii = str.length() == this.bytes.length;
        this.zeroPaddedSixPrefix = Utf8s.zeroPaddedSixPrefix(this);
    }

    public Utf8String(char ch) {
        this.bytes = String.valueOf(ch).getBytes(StandardCharsets.UTF_8);
        this.ascii = this.bytes.length == 1;
        this.zeroPaddedSixPrefix = Utf8s.zeroPaddedSixPrefix(this);
    }

    public Utf8String(@NotNull CharSequence seq) {
        this.bytes = seq.toString().getBytes(StandardCharsets.UTF_8);
        this.ascii = seq.length() == this.bytes.length;
        this.zeroPaddedSixPrefix = Utf8s.zeroPaddedSixPrefix(this);
    }

    public static Utf8String newInstance(@NotNull Utf8Sequence src) {
        byte[] bytes = new byte[src.size()];
        int n = src.size();
        for (int i = 0; i < n; ++i) {
            bytes[i] = src.byteAt(i);
        }
        return new Utf8String(bytes, src.isAscii());
    }

    @Override
    @NotNull
    public CharSequence asAsciiCharSequence() {
        return this.asciiCharSequence.of(this);
    }

    @Override
    public byte byteAt(int index) {
        return this.bytes[index];
    }

    @Override
    public int intAt(int index) {
        return Unsafe.byteArrayGetInt(this.bytes, index);
    }

    @Override
    public boolean isAscii() {
        return this.ascii;
    }

    @Override
    public long longAt(int offset) {
        return Unsafe.byteArrayGetLong(this.bytes, offset);
    }

    @Override
    public short shortAt(int index) {
        return Unsafe.byteArrayGetShort(this.bytes, index);
    }

    @Override
    public int size() {
        return this.bytes.length;
    }

    @NotNull
    public String toString() {
        return Utf8s.stringFromUtf8Bytes(this);
    }

    @Override
    public long zeroPaddedSixPrefix() {
        return this.zeroPaddedSixPrefix;
    }
}

