/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Unsafe;
import io.questdb.std.bytes.DirectByteSink;
import io.questdb.std.bytes.NativeByteSink;
import io.questdb.std.str.AsciiCharSequence;
import io.questdb.std.str.BorrowableUtf8Sink;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.MutableUtf8Sink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectUtf8Sink
implements MutableUtf8Sink,
BorrowableUtf8Sink,
DirectUtf8Sequence,
Closeable {
    private final AsciiCharSequence asciiCharSequence = new AsciiCharSequence();
    private final DirectByteSink sink;

    public DirectUtf8Sink(long initialCapacity) {
        this(initialCapacity, true);
    }

    public DirectUtf8Sink(long initialCapacity, boolean alloc) {
        this.sink = new DirectByteSink(initialCapacity, alloc, 28);
    }

    @Override
    @NotNull
    public CharSequence asAsciiCharSequence() {
        return this.asciiCharSequence.of(this);
    }

    @Override
    @NotNull
    public NativeByteSink borrowDirectByteSink() {
        return this.sink.borrowDirectByteSink();
    }

    @Override
    public byte byteAt(int index) {
        return this.sink.byteAt(index);
    }

    public long capacity() {
        return this.sink.allocatedCapacity();
    }

    @Override
    public void clear() {
        this.sink.clear();
    }

    @Override
    public void close() {
        this.sink.close();
    }

    @Override
    public boolean isAscii() {
        return this.sink.isAscii();
    }

    @Override
    public long ptr() {
        return this.sink.ptr();
    }

    @Override
    public DirectUtf8Sink put(@Nullable Utf8Sequence us) {
        if (us == null) {
            return this;
        }
        this.setAscii(this.isAscii() & us.isAscii());
        int size = us.size();
        long dest = this.sink.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            Unsafe.getUnsafe().putByte(dest + (long)i, us.byteAt(i));
        }
        this.sink.advance(size);
        return this;
    }

    @Override
    public DirectUtf8Sink put(byte b) {
        assert (b < 0) : "b is ascii";
        this.setAscii(false);
        this.sink.put(b);
        return this;
    }

    @Override
    public DirectUtf8Sink putAny(byte b) {
        this.setAscii(this.isAscii() & b >= 0);
        this.sink.put(b);
        return this;
    }

    public void putAny8(long w) {
        this.setAscii(this.isAscii() & Utf8s.isAscii(w));
        this.sink.putLong(w);
    }

    @Override
    public DirectUtf8Sink putAscii(char c) {
        this.sink.put((byte)c);
        return this;
    }

    @Override
    public DirectUtf8Sink putAscii(@Nullable CharSequence cs) {
        MutableUtf8Sink.super.putAscii(cs);
        return this;
    }

    @Override
    public DirectUtf8Sink putNonAscii(long lo, long hi) {
        this.setAscii(false);
        this.sink.put(lo, hi);
        return this;
    }

    public void reopen() {
        this.sink.reopen();
    }

    public void reserve(long minCapacity) {
        this.sink.reserve(minCapacity);
    }

    public void resetCapacity() {
        this.sink.resetCapacity();
    }

    @Override
    public int size() {
        return this.sink.size();
    }

    @Override
    public long tailPadding() {
        return this.sink.tailPadding();
    }

    @NotNull
    public String toString() {
        return Utf8s.stringFromUtf8Bytes(this.sink.lo(), this.sink.hi());
    }

    private void setAscii(boolean ascii) {
        this.sink.setAscii(ascii);
    }
}

