/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Misc;
import io.questdb.std.ObjectFactory;
import java.io.Closeable;

public class ThreadLocal<T>
extends java.lang.ThreadLocal<T>
implements Closeable {
    private final ObjectFactory<T> factory;

    public ThreadLocal(ObjectFactory<T> factory) {
        this.factory = factory;
    }

    @Override
    public void close() {
        Misc.freeIfCloseable(super.get());
        this.remove();
    }

    @Override
    public T get() {
        Object val = super.get();
        if (val == null) {
            val = this.factory.newInstance();
            this.set(val);
        }
        return val;
    }
}

