/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Mutable;
import io.questdb.std.ObjStack;
import io.questdb.std.ObjectFactory;
import org.jetbrains.annotations.NotNull;

public class ObjectStackPool<T extends Mutable>
implements Mutable {
    private static final Log LOG = LogFactory.getLog(ObjectStackPool.class);
    private final ObjectFactory<T> factory;
    private final int initialCapacity;
    private final ObjStack<T> stack;
    private int outieCount;

    public ObjectStackPool(@NotNull ObjectFactory<T> factory, int initialCapacity) {
        this.stack = new ObjStack(initialCapacity);
        this.factory = factory;
        this.initialCapacity = this.stack.getCapacity();
        this.outieCount = 0;
        this.fill(this.initialCapacity);
    }

    @Override
    public void clear() {
        this.stack.clear();
    }

    public int getCapacity() {
        return this.stack.getCapacity();
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public int getOutieCount() {
        return this.outieCount;
    }

    public int getSize() {
        return this.stack.size();
    }

    public T next() {
        if (!this.stack.notEmpty()) {
            this.expand();
        }
        ++this.outieCount;
        Mutable o = (Mutable)this.stack.pop();
        o.clear();
        return (T)o;
    }

    public void release(T o) {
        if (o == null) {
            return;
        }
        --this.outieCount;
        this.stack.push(o);
    }

    public void resetCapacity() {
        this.stack.resetCapacity();
    }

    private void expand() {
        this.fill(this.outieCount);
        LOG.debug().$("stack pool resize [class=").$(this.factory.getClass().getName()).$(", outieCount=").$(this.outieCount).$(']').$();
    }

    private void fill(int count) {
        for (int i = 0; i < count; ++i) {
            this.stack.push((Mutable)this.factory.newInstance());
        }
    }
}

