/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.BinarySequence;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class DirectByteSequenceView
implements BinarySequence,
Mutable {
    private long address;
    private long len = -1L;

    @Override
    public byte byteAt(long index) {
        return Unsafe.getUnsafe().getByte(this.address + index);
    }

    @Override
    public void clear() {
        this.len = -1L;
    }

    @Override
    public void copyTo(long address, long start, long length) {
        long bytesRemaining = Math.min(length, this.len - start);
        long addr = this.address + start;
        Vect.memcpy(address, addr, bytesRemaining);
    }

    @Override
    public long length() {
        return this.len;
    }

    public DirectByteSequenceView of(long address, long len) {
        this.address = address;
        this.len = len;
        return this;
    }

    public DirectByteSequenceView of(DirectByteSequenceView other) {
        this.address = other.address;
        this.len = other.len;
        return this;
    }
}

