/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Hash;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractUtf8SequenceHashSet
implements Mutable {
    protected static final int MIN_INITIAL_CAPACITY = 16;
    protected static final Utf8String noEntryKey = null;
    protected final int initialCapacity;
    protected final double loadFactor;
    protected int capacity;
    protected int free;
    protected int[] hashCodes;
    protected Utf8Sequence[] keys;
    protected int mask;

    public AbstractUtf8SequenceHashSet(int initialCapacity, double loadFactor) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        this.loadFactor = loadFactor;
        this.free = this.capacity = (this.initialCapacity = initialCapacity < 16 ? 16 : Numbers.ceilPow2(initialCapacity));
        int len = Numbers.ceilPow2((int)((double)this.capacity / loadFactor));
        this.keys = new Utf8String[len];
        this.hashCodes = new int[len];
        this.mask = len - 1;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, noEntryKey);
        this.free = this.capacity;
    }

    public boolean contains(@NotNull Utf8Sequence key) {
        return this.keyIndex(key) < 0;
    }

    public boolean excludes(@NotNull Utf8Sequence key) {
        return this.keyIndex(key) > -1;
    }

    public Utf8Sequence keyAt(int index) {
        return this.keys[-index - 1];
    }

    public int keyIndex(@NotNull Utf8Sequence key) {
        int hashCode = Utf8s.hashCode(key);
        int index = Hash.spread(hashCode) & this.mask;
        if (this.keys[index] == noEntryKey) {
            return index;
        }
        if (hashCode == this.hashCodes[index] && Utf8s.equals(key, this.keys[index])) {
            return -index - 1;
        }
        return this.probe(key, hashCode, index);
    }

    public int keyIndex(@NotNull Utf8Sequence key, int lo, int hi) {
        int hashCode = Utf8s.hashCode(key, lo, hi);
        int index = Hash.spread(hashCode) & this.mask;
        if (this.keys[index] == noEntryKey) {
            return index;
        }
        Utf8Sequence us = this.keys[index];
        if (hashCode == this.hashCodes[index] && Utf8s.equals(key, lo, hi, us, 0, us.size())) {
            return -index - 1;
        }
        return this.probe(key, hashCode, lo, hi, index);
    }

    public int remove(@NotNull Utf8Sequence key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            this.removeAt(index);
            return -index - 1;
        }
        return -1;
    }

    public void removeAt(int index) {
        if (index < 0) {
            int from = -index - 1;
            this.erase(from);
            ++this.free;
            from = from + 1 & this.mask;
            Utf8Sequence key = this.keys[from];
            while (key != noEntryKey) {
                int to;
                int hashCode = Utf8s.hashCode(key);
                int idealHit = Hash.spread(hashCode) & this.mask;
                if (idealHit != from && (to = this.keys[idealHit] != noEntryKey ? this.probe(key, hashCode, idealHit) : idealHit) > -1) {
                    this.move(from, to);
                }
                from = from + 1 & this.mask;
                key = this.keys[from];
            }
        }
    }

    public int size() {
        return this.capacity - this.free;
    }

    private int probe(Utf8Sequence key, int hashCode, int index) {
        do {
            if (this.keys[index = index + 1 & this.mask] != noEntryKey) continue;
            return index;
        } while (hashCode != this.hashCodes[index] || !Utf8s.equals(key, this.keys[index]));
        return -index - 1;
    }

    private int probe(Utf8Sequence key, int hashCode, int lo, int hi, int index) {
        Utf8Sequence cs;
        do {
            if (this.keys[index = index + 1 & this.mask] == noEntryKey) {
                return index;
            }
            cs = this.keys[index];
        } while (hashCode != this.hashCodes[index] || !Utf8s.equals(key, lo, hi, cs, 0, cs.size()));
        return -index - 1;
    }

    protected abstract void erase(int var1);

    protected abstract void move(int var1, int var2);
}

