/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnIndexerJob;
import io.questdb.cairo.ColumnPurgeJob;
import io.questdb.cairo.ColumnTaskJob;
import io.questdb.cairo.O3CopyJob;
import io.questdb.cairo.O3OpenColumnJob;
import io.questdb.cairo.O3PartitionJob;
import io.questdb.cairo.O3PartitionPurgeJob;
import io.questdb.cairo.sql.async.PageFrameReduceJob;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.groupby.GroupByMergeShardJob;
import io.questdb.griffin.engine.groupby.vect.GroupByVectorAggregateJob;
import io.questdb.griffin.engine.table.LatestByAllIndexedJob;
import io.questdb.mp.WorkerPool;
import io.questdb.std.NanosecondClock;
import io.questdb.std.Rnd;
import io.questdb.std.datetime.microtime.MicrosecondClock;

public class WorkerPoolUtils {
    public static void setupQueryJobs(WorkerPool sharedPoolQuery, CairoEngine cairoEngine) {
        CairoConfiguration configuration = cairoEngine.getConfiguration();
        MessageBus messageBus = cairoEngine.getMessageBus();
        int workerCount = sharedPoolQuery.getWorkerCount();
        sharedPoolQuery.assign(new LatestByAllIndexedJob(messageBus));
        if (configuration.isSqlParallelGroupByEnabled()) {
            sharedPoolQuery.assign(new GroupByVectorAggregateJob(messageBus));
            sharedPoolQuery.assign(new GroupByMergeShardJob(messageBus));
        }
        if (configuration.isSqlParallelFilterEnabled() || configuration.isSqlParallelGroupByEnabled()) {
            MicrosecondClock microsecondClock = messageBus.getConfiguration().getMicrosecondClock();
            NanosecondClock nanosecondClock = messageBus.getConfiguration().getNanosecondClock();
            for (int i = 0; i < workerCount; ++i) {
                PageFrameReduceJob pageFrameReduceJob = new PageFrameReduceJob(messageBus, new Rnd(microsecondClock.getTicks(), nanosecondClock.getTicks()), configuration.getCircuitBreakerConfiguration());
                sharedPoolQuery.assign(i, pageFrameReduceJob);
                sharedPoolQuery.freeOnExit(pageFrameReduceJob);
            }
        }
    }

    public static void setupWriterJobs(WorkerPool sharedPoolWrite, CairoEngine cairoEngine) throws SqlException {
        MessageBus messageBus = cairoEngine.getMessageBus();
        O3PartitionPurgeJob purgeDiscoveryJob = new O3PartitionPurgeJob(cairoEngine, sharedPoolWrite.getWorkerCount());
        sharedPoolWrite.freeOnExit(purgeDiscoveryJob);
        sharedPoolWrite.assign(purgeDiscoveryJob);
        if (!cairoEngine.getConfiguration().disableColumnPurgeJob()) {
            ColumnPurgeJob columnPurgeJob = new ColumnPurgeJob(cairoEngine);
            sharedPoolWrite.freeOnExit(columnPurgeJob);
            sharedPoolWrite.assign(columnPurgeJob);
        }
        sharedPoolWrite.assign(new ColumnIndexerJob(messageBus));
        sharedPoolWrite.assign(new O3PartitionJob(messageBus));
        sharedPoolWrite.assign(new O3OpenColumnJob(messageBus));
        sharedPoolWrite.assign(new O3CopyJob(messageBus));
        sharedPoolWrite.assign(new ColumnTaskJob(messageBus));
    }
}

