/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractPageFrameRecordCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntHashSet;
import io.questdb.std.Misc;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LatestByValueListRecordCursor
extends AbstractPageFrameRecordCursor {
    private final int columnIndex;
    private final Function filter;
    private final boolean restrictedByExcludedValues;
    private final boolean restrictedByIncludedValues;
    private final DirectLongList rowIds;
    private final int shrinkToCapacity;
    private boolean areRecordsFound;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private int currentRow;
    private IntHashSet excludedSymbolKeys;
    private IntHashSet foundKeys;
    private int foundSize;
    private IntHashSet includedSymbolKeys;

    public LatestByValueListRecordCursor(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, int columnIndex, @Nullable Function filter, int shrinkToCapacity, boolean restrictedByIncludedValues, boolean restrictedByExcludedValues) {
        super(configuration, metadata);
        this.shrinkToCapacity = shrinkToCapacity;
        this.columnIndex = columnIndex;
        this.filter = filter;
        this.restrictedByIncludedValues = restrictedByIncludedValues;
        this.restrictedByExcludedValues = restrictedByExcludedValues;
        if (restrictedByIncludedValues || restrictedByExcludedValues) {
            this.includedSymbolKeys = new IntHashSet(shrinkToCapacity);
            this.excludedSymbolKeys = new IntHashSet(shrinkToCapacity);
        }
        this.foundKeys = new IntHashSet(shrinkToCapacity);
        this.rowIds = new DirectLongList(shrinkToCapacity, 42);
    }

    @Override
    public void close() {
        super.close();
        if (this.rowIds.getCapacity() > (long)this.shrinkToCapacity) {
            this.foundKeys = new IntHashSet(this.shrinkToCapacity);
        }
        Misc.free(this.rowIds);
    }

    @Override
    public boolean hasNext() {
        if (!this.areRecordsFound) {
            this.findRecords();
            this.toTop();
            this.areRecordsFound = true;
        }
        if (this.currentRow-- > 0) {
            long rowId = this.rowIds.get(this.currentRow);
            this.frameMemoryPool.navigateTo(Rows.toPartitionIndex(rowId), this.recordA);
            this.recordA.setRowIndex(Rows.toLocalRowID(rowId));
            return true;
        }
        return false;
    }

    @Override
    public void of(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.frameCursor = pageFrameCursor;
        this.rowIds.reopen();
        this.recordA.of(pageFrameCursor);
        this.recordB.of(pageFrameCursor);
        this.circuitBreaker = executionContext.getCircuitBreaker();
        pageFrameCursor.toTop();
        this.foundSize = 0;
        this.foundKeys.clear();
        this.rowIds.clear();
        if (this.filter != null) {
            this.filter.init(pageFrameCursor, executionContext);
            this.filter.toTop();
        }
        if (this.restrictedByIncludedValues) {
            if (this.includedSymbolKeys.size() > 0) {
                this.rowIds.setCapacity(this.includedSymbolKeys.size());
            }
        } else if (this.restrictedByExcludedValues) {
            StaticSymbolTable symbolTable = pageFrameCursor.getSymbolTable(this.columnIndex);
            int distinctSymbols = symbolTable.getSymbolCount();
            if (symbolTable.containsNullValue()) {
                ++distinctSymbols;
            } else if (this.excludedSymbolKeys.contains(Integer.MIN_VALUE)) {
                ++distinctSymbols;
            }
            if ((distinctSymbols -= this.excludedSymbolKeys.size()) > 0) {
                this.rowIds.setCapacity(distinctSymbols);
            }
        } else {
            StaticSymbolTable symbolTable = pageFrameCursor.getSymbolTable(this.columnIndex);
            int distinctSymbols = symbolTable.getSymbolCount();
            if (symbolTable.containsNullValue()) {
                ++distinctSymbols;
            }
            if (distinctSymbols > 0) {
                this.rowIds.setCapacity(distinctSymbols);
            }
        }
        this.areRecordsFound = false;
        super.init();
    }

    @Override
    public long size() {
        return this.areRecordsFound ? this.rowIds.size() : -1L;
    }

    @Override
    public long preComputedStateSize() {
        return this.rowIds.size();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("FilterOnValueList").meta("on").putColumnName(this.columnIndex);
    }

    @Override
    public void toTop() {
        this.currentRow = (int)this.rowIds.size();
    }

    private void findAllNoFilter(int distinctCount) {
        PageFrame frame;
        assert (this.filter == null);
        while ((frame = this.frameCursor.next()) != null) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            int frameIndex = this.frameCount;
            long partitionLo = frame.getPartitionLo();
            long partitionHi = frame.getPartitionHi() - 1L;
            this.frameAddressCache.add(this.frameCount, frame);
            this.frameMemoryPool.navigateTo(this.frameCount++, this.recordA);
            for (long row = partitionHi - partitionLo; row >= 0L; --row) {
                this.recordA.setRowIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frameIndex, row));
                if (++this.foundSize != distinctCount) continue;
                return;
            }
        }
    }

    private void findAllWithFilter(int distinctCount) {
        PageFrame frame;
        assert (this.filter != null);
        while ((frame = this.frameCursor.next()) != null) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            int frameIndex = this.frameCount;
            long partitionLo = frame.getPartitionLo();
            long partitionHi = frame.getPartitionHi() - 1L;
            this.frameAddressCache.add(this.frameCount, frame);
            this.frameMemoryPool.navigateTo(this.frameCount++, this.recordA);
            for (long row = partitionHi - partitionLo; row >= 0L; --row) {
                this.recordA.setRowIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!this.filter.getBool(this.recordA) || !this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frameIndex, row));
                if (++this.foundSize != distinctCount) continue;
                return;
            }
        }
    }

    private void findRecords() {
        if (this.restrictedByIncludedValues) {
            if (this.includedSymbolKeys.size() > 0) {
                if (this.filter != null) {
                    this.findRestrictedWithFilter();
                } else {
                    this.findRestrictedNoFilter();
                }
            }
        } else if (this.restrictedByExcludedValues) {
            int distinctSymbols = (int)this.rowIds.getCapacity();
            if (this.filter != null) {
                this.findRestrictedExcludedOnlyWithFilter(distinctSymbols);
            } else {
                this.findRestrictedExcludedOnlyNoFilter(distinctSymbols);
            }
        } else {
            int distinctSymbols = (int)this.rowIds.getCapacity();
            if (distinctSymbols > 0) {
                if (this.filter != null) {
                    this.findAllWithFilter(distinctSymbols);
                } else {
                    this.findAllNoFilter(distinctSymbols);
                }
            }
        }
    }

    private void findRestrictedExcludedOnlyNoFilter(int distinctCount) {
        PageFrame frame;
        assert (this.filter == null);
        while ((frame = this.frameCursor.next()) != null) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            int frameIndex = this.frameCount;
            long partitionLo = frame.getPartitionLo();
            long partitionHi = frame.getPartitionHi() - 1L;
            this.frameAddressCache.add(this.frameCount, frame);
            this.frameMemoryPool.navigateTo(this.frameCount++, this.recordA);
            for (long row = partitionHi - partitionLo; row >= 0L; --row) {
                this.recordA.setRowIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!this.excludedSymbolKeys.excludes(key) || !this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frameIndex, row));
                if (++this.foundSize != distinctCount) continue;
                return;
            }
        }
    }

    private void findRestrictedExcludedOnlyWithFilter(int distinctCount) {
        PageFrame frame;
        assert (this.filter != null);
        while ((frame = this.frameCursor.next()) != null) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            int frameIndex = this.frameCount;
            long partitionLo = frame.getPartitionLo();
            long partitionHi = frame.getPartitionHi() - 1L;
            this.frameAddressCache.add(this.frameCount, frame);
            this.frameMemoryPool.navigateTo(this.frameCount++, this.recordA);
            for (long row = partitionHi - partitionLo; row >= 0L; --row) {
                this.recordA.setRowIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!this.filter.getBool(this.recordA) || !this.excludedSymbolKeys.excludes(key) || !this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frameIndex, row));
                if (++this.foundSize != distinctCount) continue;
                return;
            }
        }
    }

    private void findRestrictedNoFilter() {
        PageFrame frame;
        assert (this.filter == null);
        int searchSize = this.includedSymbolKeys.size();
        while ((frame = this.frameCursor.next()) != null) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            int frameIndex = this.frameCount;
            long partitionLo = frame.getPartitionLo();
            long partitionHi = frame.getPartitionHi() - 1L;
            this.frameAddressCache.add(this.frameCount, frame);
            this.frameMemoryPool.navigateTo(this.frameCount++, this.recordA);
            for (long row = partitionHi - partitionLo; row >= 0L; --row) {
                this.recordA.setRowIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!this.includedSymbolKeys.contains(key) || !this.excludedSymbolKeys.excludes(key) || !this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frameIndex, row));
                if (++this.foundSize != searchSize) continue;
                return;
            }
        }
    }

    private void findRestrictedWithFilter() {
        PageFrame frame;
        assert (this.filter != null);
        int searchSize = this.includedSymbolKeys.size();
        while ((frame = this.frameCursor.next()) != null) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            int frameIndex = this.frameCount;
            long partitionLo = frame.getPartitionLo();
            long partitionHi = frame.getPartitionHi() - 1L;
            this.frameAddressCache.add(this.frameCount, frame);
            this.frameMemoryPool.navigateTo(this.frameCount++, this.recordA);
            for (long row = partitionHi - partitionLo; row >= 0L; --row) {
                this.recordA.setRowIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!this.filter.getBool(this.recordA) || !this.includedSymbolKeys.contains(key) || !this.excludedSymbolKeys.excludes(key) || !this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frameIndex, row));
                if (++this.foundSize != searchSize) continue;
                return;
            }
        }
    }

    IntHashSet getExcludedSymbolKeys() {
        return this.excludedSymbolKeys;
    }

    IntHashSet getIncludedSymbolKeys() {
        return this.includedSymbolKeys;
    }
}

