/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PartitionFrameCursor;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.cairo.sql.SingleSymbolFilter;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.PageFrameRecordCursorFactory;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class DeferredSingleSymbolFilterPageFrameRecordCursorFactory
extends PageFrameRecordCursorFactory {
    private final int symbolColumnIndex;
    private final SingleSymbolFilter symbolFilter;
    private final Function symbolFunc;
    private boolean convertedToFrame;
    private int symbolKey;

    public DeferredSingleSymbolFilterPageFrameRecordCursorFactory(@NotNull CairoConfiguration configuration, int symbolColumnIndex, Function symbolFunc, RowCursorFactory rowCursorFactory, RecordMetadata metadata, PartitionFrameCursorFactory partitionFrameCursorFactory, boolean followsOrderByAdvice, @NotNull IntList columnIndexes, @NotNull IntList columnSizes, boolean supportsRandomAccess) {
        super(configuration, metadata, partitionFrameCursorFactory, rowCursorFactory, followsOrderByAdvice, null, false, columnIndexes, columnSizes, supportsRandomAccess, false);
        this.symbolFunc = symbolFunc;
        this.symbolKey = -2;
        this.symbolColumnIndex = symbolColumnIndex;
        this.symbolFilter = new SingleSymbolFilter(){

            @Override
            public int getColumnIndex() {
                return DeferredSingleSymbolFilterPageFrameRecordCursorFactory.this.symbolColumnIndex;
            }

            @Override
            public int getSymbolFilterKey() {
                return DeferredSingleSymbolFilterPageFrameRecordCursorFactory.this.symbolKey;
            }
        };
    }

    @Override
    public SingleSymbolFilter convertToSampleByIndexPageFrameCursorFactory() {
        this.convertedToFrame = true;
        return this.symbolFilter;
    }

    @Override
    public String getBaseColumnName(int columnIndex) {
        return this.getMetadata().getColumnName(columnIndex);
    }

    @Override
    public PageFrameCursor getPageFrameCursor(SqlExecutionContext executionContext, int order) throws SqlException {
        assert (this.convertedToFrame);
        PartitionFrameCursor partitionFrameCursor = this.partitionFrameCursorFactory.getCursor(executionContext, order);
        this.initFwdPageFrameCursor(partitionFrameCursor, executionContext);
        try {
            if (this.symbolKey == -2) {
                CharSequence symbol = this.symbolFunc.getStrA(null);
                StaticSymbolTable symbolMapReader = this.fwdPageFrameCursor.getSymbolTable(this.symbolColumnIndex);
                this.symbolKey = symbolMapReader.keyOf(symbol);
                if (this.symbolKey != -2) {
                    this.symbolKey = TableUtils.toIndexKey(this.symbolKey);
                }
            }
            return this.fwdPageFrameCursor;
        }
        catch (Throwable th) {
            Misc.free(this.fwdPageFrameCursor);
            throw th;
        }
    }

    @Override
    public void revertFromSampleByIndexPageFrameCursorFactory() {
        this.convertedToFrame = false;
    }

    @Override
    public boolean supportsPageFrameCursor() {
        return this.convertedToFrame;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("DeferredSingleSymbolFilterPageFrame");
        super.toPlanInner(sink);
    }

    @Override
    protected RecordCursor initRecordCursor(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        assert (!this.convertedToFrame);
        return super.initRecordCursor(pageFrameCursor, executionContext);
    }
}

