/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameAddressCache;
import io.questdb.cairo.sql.PageFrameMemoryPool;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.StatefulAtom;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.PerWorkerLocks;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.orderby.LimitedSizeLongTreeChain;
import io.questdb.griffin.engine.orderby.RecordComparatorCompiler;
import io.questdb.jit.CompiledFilter;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncTopKAtom
implements StatefulAtom,
Reopenable,
Plannable {
    private final ObjList<Function> bindVarFunctions;
    private final MemoryCARW bindVarMemory;
    private final CompiledFilter compiledFilter;
    private final LimitedSizeLongTreeChain ownerChain;
    private final RecordComparator ownerComparator;
    private final Function ownerFilter;
    private final PageFrameMemoryPool ownerMemoryPool;
    private final PageFrameMemoryRecord ownerRecordA;
    private final PageFrameMemoryRecord ownerRecordB;
    private final ObjList<LimitedSizeLongTreeChain> perWorkerChains;
    private final ObjList<RecordComparator> perWorkerComparators;
    private final ObjList<Function> perWorkerFilters;
    private final PerWorkerLocks perWorkerLocks;
    private final ObjList<PageFrameMemoryPool> perWorkerMemoryPools;
    private final ObjList<PageFrameMemoryRecord> perWorkerRecordsB;
    private final int workerCount;

    public AsyncTopKAtom(@NotNull CairoConfiguration configuration, @Nullable Function ownerFilter, @Nullable ObjList<Function> perWorkerFilters, @Nullable CompiledFilter compiledFilter, @Nullable MemoryCARW bindVarMemory, @Nullable ObjList<Function> bindVarFunctions, @NotNull RecordComparatorCompiler recordComparatorCompiler, @NotNull ListColumnFilter orderByFilter, @NotNull RecordMetadata orderByMetadata, long lo, int workerCount) {
        assert (perWorkerFilters == null || perWorkerFilters.size() == workerCount);
        try {
            this.ownerFilter = ownerFilter;
            this.perWorkerFilters = perWorkerFilters;
            this.compiledFilter = compiledFilter;
            this.bindVarMemory = bindVarMemory;
            this.bindVarFunctions = bindVarFunctions;
            Class<RecordComparator> clazz = recordComparatorCompiler.compile(orderByMetadata, orderByFilter);
            this.ownerComparator = recordComparatorCompiler.newInstance(clazz);
            this.ownerMemoryPool = new PageFrameMemoryPool(configuration.getSqlParquetFrameCacheCapacity());
            this.ownerRecordA = new PageFrameMemoryRecord(0);
            this.ownerRecordB = new PageFrameMemoryRecord(1);
            this.ownerChain = new LimitedSizeLongTreeChain(configuration.getSqlSortKeyPageSize(), configuration.getSqlSortKeyMaxPages(), configuration.getSqlSortLightValuePageSize(), configuration.getSqlSortLightValueMaxPages());
            this.ownerChain.updateLimits(true, lo);
            this.workerCount = workerCount;
            this.perWorkerLocks = new PerWorkerLocks(configuration, workerCount);
            this.perWorkerComparators = new ObjList(workerCount);
            this.perWorkerChains = new ObjList(workerCount);
            this.perWorkerMemoryPools = new ObjList(workerCount);
            this.perWorkerRecordsB = new ObjList(workerCount);
            for (int i = 0; i < workerCount; ++i) {
                this.perWorkerComparators.extendAndSet(i, recordComparatorCompiler.newInstance(clazz));
                LimitedSizeLongTreeChain chain = new LimitedSizeLongTreeChain(configuration.getSqlSortKeyPageSize(), configuration.getSqlSortKeyMaxPages(), configuration.getSqlSortLightValuePageSize(), configuration.getSqlSortLightValueMaxPages());
                chain.updateLimits(true, lo);
                this.perWorkerChains.extendAndSet(i, chain);
                this.perWorkerMemoryPools.extendAndSet(i, new PageFrameMemoryPool(2));
                this.perWorkerRecordsB.extendAndSet(i, new PageFrameMemoryRecord(1));
            }
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void clear() {
        Misc.free(this.ownerChain);
        Misc.free(this.ownerMemoryPool);
        Misc.free(this.ownerRecordB);
        this.freePerWorkerChainsAndPools();
    }

    @Override
    public void close() {
        this.clear();
        Misc.free(this.ownerFilter);
        Misc.freeObjList(this.perWorkerFilters);
        Misc.free(this.compiledFilter);
        Misc.free(this.bindVarMemory);
        Misc.freeObjList(this.bindVarFunctions);
    }

    public void freePerWorkerChainsAndPools() {
        Misc.freeObjListAndKeepObjects(this.perWorkerChains);
        Misc.freeObjListAndKeepObjects(this.perWorkerMemoryPools);
        Misc.freeObjListAndKeepObjects(this.perWorkerRecordsB);
    }

    public ObjList<Function> getBindVarFunctions() {
        return this.bindVarFunctions;
    }

    public MemoryCARW getBindVarMemory() {
        return this.bindVarMemory;
    }

    public RecordComparator getComparator(int slotId) {
        if (slotId == -1) {
            return this.ownerComparator;
        }
        return this.perWorkerComparators.getQuick(slotId);
    }

    public CompiledFilter getCompiledFilter() {
        return this.compiledFilter;
    }

    public Function getFilter(int slotId) {
        if (slotId == -1 || this.perWorkerFilters == null) {
            return this.ownerFilter;
        }
        return this.perWorkerFilters.getQuick(slotId);
    }

    public PageFrameMemoryPool getMemoryPool(int slotId) {
        if (slotId == -1) {
            return this.ownerMemoryPool;
        }
        return this.perWorkerMemoryPools.getQuick(slotId);
    }

    public LimitedSizeLongTreeChain getOwnerChain() {
        return this.ownerChain;
    }

    public RecordComparator getOwnerComparator() {
        return this.ownerComparator;
    }

    public PageFrameMemoryPool getOwnerMemoryPool() {
        return this.ownerMemoryPool;
    }

    public PageFrameMemoryRecord getOwnerRecordA() {
        return this.ownerRecordA;
    }

    public PageFrameMemoryRecord getOwnerRecordB() {
        return this.ownerRecordB;
    }

    public ObjList<LimitedSizeLongTreeChain> getPerWorkerChains() {
        return this.perWorkerChains;
    }

    public PageFrameMemoryRecord getRecordB(int slotId) {
        if (slotId == -1) {
            return this.ownerRecordB;
        }
        return this.perWorkerRecordsB.getQuick(slotId);
    }

    public LimitedSizeLongTreeChain getTreeChain(int slotId) {
        if (slotId == -1) {
            return this.ownerChain;
        }
        return this.perWorkerChains.getQuick(slotId);
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        if (this.ownerFilter != null) {
            this.ownerFilter.init(symbolTableSource, executionContext);
        }
        if (this.perWorkerFilters != null) {
            boolean current = executionContext.getCloneSymbolTables();
            executionContext.setCloneSymbolTables(true);
            try {
                Function.init(this.perWorkerFilters, symbolTableSource, executionContext, this.ownerFilter);
            }
            finally {
                executionContext.setCloneSymbolTables(current);
            }
        }
        this.ownerRecordA.of(symbolTableSource);
        this.ownerRecordB.of(symbolTableSource);
        for (int i = 0; i < this.workerCount; ++i) {
            this.perWorkerRecordsB.getQuick(i).of(symbolTableSource);
        }
    }

    public void initMemoryPools(PageFrameAddressCache pageFrameAddressCache) {
        this.ownerMemoryPool.of(pageFrameAddressCache);
        for (int i = 0; i < this.workerCount; ++i) {
            this.perWorkerMemoryPools.getQuick(i).of(pageFrameAddressCache);
        }
    }

    public int maybeAcquire(int workerId, boolean owner, SqlExecutionCircuitBreaker circuitBreaker) {
        if (workerId == -1 && owner) {
            return -1;
        }
        return this.perWorkerLocks.acquireSlot(workerId, circuitBreaker);
    }

    public void release(int slotId) {
        this.perWorkerLocks.releaseSlot(slotId);
    }

    @Override
    public void reopen() {
        this.ownerChain.reopen();
        int n = this.perWorkerChains.size();
        for (int i = 0; i < n; ++i) {
            this.perWorkerChains.getQuick(i).reopen();
        }
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.ownerFilter);
    }
}

