/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.groupby.vect.DistinctFunc;
import io.questdb.griffin.engine.groupby.vect.KeyValueFunc;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Numbers;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.function.DoubleBinaryOperator;

public class MaxDoubleVectorAggregateFunction
extends DoubleFunction
implements VectorAggregateFunction {
    public static final DoubleBinaryOperator MAX = Math::max;
    private final int columnIndex;
    private final DistinctFunc distinctFunc;
    private final KeyValueFunc keyValueFunc;
    private final DoubleAccumulator max = new DoubleAccumulator(MAX, Double.NEGATIVE_INFINITY);
    private int valueOffset;

    public MaxDoubleVectorAggregateFunction(int keyKind, int columnIndex, int workerCount) {
        this.columnIndex = columnIndex;
        if (keyKind == 1) {
            this.distinctFunc = Rosti::keyedHourDistinct;
            this.keyValueFunc = Rosti::keyedHourMaxDouble;
        } else {
            this.distinctFunc = Rosti::keyedIntDistinct;
            this.keyValueFunc = Rosti::keyedIntMaxDouble;
        }
    }

    @Override
    public void aggregate(long address, long frameRowCount, int workerId) {
        double value;
        if (address != 0L && Numbers.isFinite(value = Vect.maxDouble(address, frameRowCount))) {
            this.max.accumulate(value);
        }
    }

    @Override
    public boolean aggregate(long pRosti, long keyAddress, long valueAddress, long frameRowCount) {
        if (valueAddress == 0L) {
            return this.distinctFunc.run(pRosti, keyAddress, frameRowCount);
        }
        return this.keyValueFunc.run(pRosti, keyAddress, valueAddress, frameRowCount, this.valueOffset);
    }

    @Override
    public void clear() {
        this.max.reset();
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public double getDouble(Record rec) {
        double value = this.max.get();
        return Double.isInfinite(value) ? Double.NaN : value;
    }

    @Override
    public String getName() {
        return "max";
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putDouble(Rosti.getInitialValueSlot(pRosti, this.valueOffset), Double.NEGATIVE_INFINITY);
    }

    @Override
    public boolean merge(long pRostiA, long pRostiB) {
        return Rosti.keyedIntMaxDoubleMerge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(10);
    }

    @Override
    public boolean wrapUp(long pRosti) {
        return Rosti.keyedIntMaxDoubleWrapUp(pRosti, this.valueOffset, this.max.get());
    }
}

