/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.OrderedMap;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class DistinctTimeSeriesRecordCursorFactory
extends AbstractRecordCursorFactory {
    protected final RecordCursorFactory base;
    private final DistinctTimeSeriesRecordCursor cursor;

    public DistinctTimeSeriesRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, @NotNull EntityColumnFilter columnFilter, @NotNull BytecodeAssembler asm) {
        super(base.getMetadata());
        this.base = base;
        try {
            assert (base.recordCursorSupportsRandomAccess());
            RecordMetadata metadata = base.getMetadata();
            columnFilter.of(metadata.getColumnCount());
            RecordSink recordSink = RecordSinkFactory.getInstance(asm, metadata, columnFilter);
            OrderedMap dataMap = new OrderedMap(configuration.getSqlSmallMapPageSize(), metadata, configuration.getSqlDistinctTimestampKeyCapacity(), configuration.getSqlDistinctTimestampLoadFactor(), Integer.MAX_VALUE);
            this.cursor = new DistinctTimeSeriesRecordCursor(this.getMetadata().getTimestampIndex(), dataMap, recordSink);
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            return this.cursor.of(baseCursor, executionContext);
        }
        catch (Throwable th) {
            this.cursor.close();
            throw th;
        }
    }

    @Override
    public int getScanDirection() {
        return this.base.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("DistinctTimeSeries");
        sink.attr("keys").val(this.getMetadata());
        sink.child(this.base);
    }

    @Override
    protected void _close() {
        Misc.free(this.base);
        Misc.free(this.cursor);
    }

    private static class DistinctTimeSeriesRecordCursor
    implements RecordCursor {
        private static final byte COMPUTE_NEXT = 1;
        private static final byte INIT_FIRST_TIMESTAMP = 0;
        private static final byte NO_ROWS = 3;
        private static final byte REUSE_CURRENT = 2;
        private final Map dataMap;
        private final RecordSink recordSink;
        private final int timestampIndex;
        private RecordCursor baseCursor;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isOpen;
        private long prevRowId;
        private long prevTimestamp;
        private Record record;
        private Record recordB;
        private byte state = 0;

        public DistinctTimeSeriesRecordCursor(int timestampIndex, Map dataMap, RecordSink recordSink) {
            this.timestampIndex = timestampIndex;
            this.dataMap = dataMap;
            this.recordSink = recordSink;
            this.isOpen = true;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.baseCursor = Misc.free(this.baseCursor);
                Misc.free(this.dataMap);
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public Record getRecordB() {
            return this.baseCursor.getRecordB();
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.baseCursor.getSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            if (this.state == 0) {
                if (this.baseCursor.hasNext()) {
                    this.prevTimestamp = this.record.getTimestamp(this.timestampIndex);
                    this.prevRowId = this.record.getRowId();
                    this.state = (byte)2;
                } else {
                    this.state = (byte)3;
                }
            }
            if (this.state == 1) {
                while (this.baseCursor.hasNext()) {
                    this.circuitBreaker.statefulThrowExceptionIfTripped();
                    long timestamp = this.record.getTimestamp(this.timestampIndex);
                    if (timestamp != this.prevTimestamp) {
                        this.prevTimestamp = timestamp;
                        this.prevRowId = this.record.getRowId();
                        return true;
                    }
                    if (!this.checkIfNotDupe()) continue;
                    return true;
                }
                return false;
            }
            boolean next = this.state == 2;
            this.state = 1;
            return next;
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.baseCursor.newSymbolTable(columnIndex);
        }

        public RecordCursor of(RecordCursor baseCursor, SqlExecutionContext sqlExecutionContext) {
            this.baseCursor = baseCursor;
            this.record = baseCursor.getRecord();
            this.recordB = baseCursor.getRecordB();
            if (!this.isOpen) {
                this.isOpen = true;
                this.dataMap.reopen();
            }
            this.circuitBreaker = sqlExecutionContext.getCircuitBreaker();
            this.state = 0;
            return this;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.baseCursor.recordAt(record, atRowId);
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.baseCursor.toTop();
            this.dataMap.clear();
        }

        private boolean checkIfNotDupe() {
            MapKey key;
            if (this.prevRowId != -1L) {
                this.baseCursor.recordAt(this.recordB, this.prevRowId);
                this.dataMap.clear();
                key = this.dataMap.withKey();
                this.recordSink.copy(this.recordB, key);
                key.create();
                this.prevRowId = -1L;
            }
            key = this.dataMap.withKey();
            this.recordSink.copy(this.record, key);
            return key.create();
        }
    }
}

