/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public class LeftStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "left(SI)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function strFunc = args.getQuick(0);
        Function countFunc = args.getQuick(1);
        if (countFunc.isConstant()) {
            int count = countFunc.getInt(null);
            if (count != Integer.MIN_VALUE) {
                return new ConstCountFunc(strFunc, count);
            }
            return StrConstant.NULL;
        }
        return new Func(strFunc, countFunc);
    }

    private static int getPos(int len, int count) {
        return count > -1 ? Math.max(0, Math.min(len, count)) : Math.max(0, len + count);
    }

    private static class ConstCountFunc
    extends StrFunction
    implements UnaryFunction {
        private final int count;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();
        private final Function strFunc;

        public ConstCountFunc(Function strFunc, int count) {
            this.strFunc = strFunc;
            this.count = count;
        }

        @Override
        public Function getArg() {
            return this.strFunc;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return this.getStr0(rec, this.sinkA);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStr0(rec, this.sinkB);
        }

        @Override
        public int getStrLen(Record rec) {
            int len = this.strFunc.getStrLen(rec);
            return len != -1 ? this.getPos(len) : -1;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("left(").val(this.strFunc).val(',').val(this.count).val(')');
        }

        private int getPos(int len) {
            return LeftStrFunctionFactory.getPos(len, this.count);
        }

        @Nullable
        private StringSink getStr0(Record rec, StringSink sink) {
            CharSequence str = this.strFunc.getStrA(rec);
            if (str != null) {
                int len = str.length();
                int pos = this.getPos(len);
                sink.clear();
                sink.put(str, 0, pos);
                return sink;
            }
            return null;
        }
    }

    private static class Func
    extends StrFunction
    implements BinaryFunction {
        private final Function countFunc;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();
        private final Function strFunc;

        public Func(Function strFunc, Function countFunc) {
            this.strFunc = strFunc;
            this.countFunc = countFunc;
        }

        @Override
        public Function getLeft() {
            return this.strFunc;
        }

        @Override
        public String getName() {
            return "left";
        }

        @Override
        public Function getRight() {
            return this.countFunc;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return this.getStr0(rec, this.sinkA);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStr0(rec, this.sinkB);
        }

        @Override
        public int getStrLen(Record rec) {
            int count = this.countFunc.getInt(rec);
            int len = this.strFunc.getStrLen(rec);
            if (len != -1 && count != Integer.MIN_VALUE) {
                return LeftStrFunctionFactory.getPos(len, count);
            }
            return -1;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Nullable
        private StringSink getStr0(Record rec, StringSink sink) {
            CharSequence str = this.strFunc.getStrA(rec);
            int count = this.countFunc.getInt(rec);
            if (str != null && count != Integer.MIN_VALUE) {
                int len = str.length();
                int pos = LeftStrFunctionFactory.getPos(len, count);
                sink.clear();
                sink.put(str, 0, pos);
                return sink;
            }
            return null;
        }
    }
}

