/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.regex;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.regex.RegexUtils;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class RegexpReplaceStrFunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "regexp_replace(SSS)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function pattern = args.getQuick(1);
        int patternPos = argPositions.getQuick(1);
        Function replacement = args.getQuick(2);
        int replacementPos = argPositions.getQuick(2);
        this.validateInputs(pattern, patternPos, replacement, replacementPos);
        Function value = args.getQuick(0);
        int maxLength = configuration.getStrFunctionMaxBufferLength();
        return new RegexpReplaceStrFunction(value, pattern, patternPos, replacement, maxLength, position);
    }

    protected void validateInputs(Function pattern, int patternPos, Function replacement, int replacementPos) throws SqlException {
        if (!pattern.isConstant() && !pattern.isRuntimeConstant()) {
            throw SqlException.$(patternPos, "not implemented: dynamic pattern would be very slow to execute");
        }
        if (!replacement.isConstant() && !replacement.isRuntimeConstant()) {
            throw SqlException.$(replacementPos, "not implemented: dynamic replacement would be slow to execute");
        }
    }

    protected static class RegexpReplaceStrFunction
    extends StrFunction
    implements UnaryFunction {
        private final int functionPos;
        private final int maxLength;
        private final Function pattern;
        private final int patternPos;
        private final Function replacement;
        private final StringBuilderSink sinkA = new StringBuilderSink();
        private final StringBuilderSink sinkB = new StringBuilderSink();
        private final Function value;
        private Matcher matcher;
        private String replacementStr;

        public RegexpReplaceStrFunction(Function value, Function pattern, int patternPos, Function replacement, int maxLength, int functionPos) {
            this.value = value;
            this.pattern = pattern;
            this.patternPos = patternPos;
            this.replacement = replacement;
            this.maxLength = maxLength;
            this.functionPos = functionPos;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        public CharSequence getStr(Record rec, StringBuilderSink sink) {
            if (this.matcher == null || this.replacementStr == null) {
                return null;
            }
            CharSequence cs = this.value.getStrA(rec);
            if (cs == null) {
                return null;
            }
            this.matcher.reset(cs);
            sink.clear();
            try {
                boolean result = this.matcher.find();
                if (!result) {
                    sink.buffer.append(cs);
                } else {
                    do {
                        if (sink.length() > this.maxLength) {
                            throw CairoException.critical(0).put("breached memory limit set for ").put(RegexpReplaceStrFunctionFactory.SIGNATURE).put(" [maxLength=").put(this.maxLength).put(']');
                        }
                        this.matcher.appendReplacement(sink.buffer, this.replacementStr);
                    } while (result = this.matcher.find());
                    this.matcher.appendTail(sink.buffer);
                }
                return sink;
            }
            catch (CairoException e) {
                throw e;
            }
            catch (Throwable e) {
                throw CairoException.critical(0).put("regexp_replace failed [position=").put(this.functionPos).put(", ex=").put(e.getMessage()).put(']');
            }
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return this.getStr(rec, this.sinkA);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStr(rec, this.sinkB);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            UnaryFunction.super.init(symbolTableSource, executionContext);
            this.pattern.init(symbolTableSource, executionContext);
            this.matcher = RegexUtils.createMatcher(this.pattern, this.patternPos);
            this.replacement.init(symbolTableSource, executionContext);
            CharSequence cs = this.replacement.getStrA(null);
            this.replacementStr = cs == null ? null : cs.toString();
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean isRuntimeConstant() {
            return false;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("regexp_replace(").val(this.value).val(',').val(this.pattern).val(',').val(this.replacement).val(')');
        }
    }

    private static class StringBuilderSink
    implements CharSequence {
        private final StringBuilder buffer = new StringBuilder();

        private StringBuilderSink() {
        }

        @Override
        public char charAt(int index) {
            return this.buffer.charAt(index);
        }

        public void clear() {
            this.buffer.setLength(0);
        }

        public boolean equals(Object obj) {
            return obj instanceof CharSequence && Chars.equals((CharSequence)this.buffer, (CharSequence)obj);
        }

        public int hashCode() {
            return Chars.hashCode(this.buffer);
        }

        @Override
        public int length() {
            return this.buffer.length();
        }

        @Override
        @NotNull
        public CharSequence subSequence(int lo, int hi) {
            return this.buffer.subSequence(lo, hi);
        }

        @Override
        @NotNull
        public String toString() {
            return this.buffer.toString();
        }
    }
}

