/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.CharFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class MinCharGroupByFunction
extends CharFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public MinCharGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        mapValue.putChar(this.valueIndex, this.arg.getChar(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        char min = mapValue.getChar(this.valueIndex);
        char next = this.arg.getChar(record);
        if (next > '\u0000' && next < min) {
            mapValue.putChar(this.valueIndex, next);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public char getChar(Record rec) {
        return rec.getChar(this.valueIndex);
    }

    @Override
    public String getName() {
        return "min";
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(4);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return UnaryFunction.super.isThreadSafe();
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        char srcMin = srcValue.getChar(this.valueIndex);
        char destMin = destValue.getChar(this.valueIndex);
        if (srcMin != '\u0000' && (srcMin < destMin || destMin == '\u0000')) {
            destValue.putInt(this.valueIndex, srcMin);
        }
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putChar(this.valueIndex, '\u0000');
    }

    @Override
    public boolean supportsParallelism() {
        return UnaryFunction.super.supportsParallelism();
    }
}

