/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.groupby.FirstUuidGroupByFunction;
import org.jetbrains.annotations.NotNull;

public final class LastUuidGroupByFunction
extends FirstUuidGroupByFunction {
    public LastUuidGroupByFunction(@NotNull Function arg) {
        super(arg);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        this.computeFirst(mapValue, record, rowId);
    }

    @Override
    public String getName() {
        return "last";
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long destRowId;
        long srcRowId = srcValue.getLong(this.valueIndex);
        if (srcRowId > (destRowId = destValue.getLong(this.valueIndex))) {
            destValue.putLong(this.valueIndex, srcRowId);
            destValue.putLong128(this.valueIndex + 1, srcValue.getLong128Lo(this.valueIndex + 1), srcValue.getLong128Hi(this.valueIndex + 1));
        }
    }
}

