/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.groupby.FirstUuidGroupByFunction;
import io.questdb.std.Uuid;

public class LastNotNullUuidGroupByFunction
extends FirstUuidGroupByFunction {
    public LastNotNullUuidGroupByFunction(Function arg) {
        super(arg);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        if (!Uuid.isNull(this.arg.getLong128Lo(record), this.arg.getLong128Hi(record))) {
            this.computeFirst(mapValue, record, rowId);
        }
    }

    @Override
    public String getName() {
        return "last_not_null";
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long destRowId;
        long srcValHi;
        long srcValLo = srcValue.getLong128Lo(this.valueIndex + 1);
        if (Uuid.isNull(srcValLo, srcValHi = srcValue.getLong128Hi(this.valueIndex + 1))) {
            return;
        }
        long srcRowId = srcValue.getLong(this.valueIndex);
        if (srcRowId > (destRowId = destValue.getLong(this.valueIndex))) {
            destValue.putLong(this.valueIndex, srcRowId);
            destValue.putLong128(this.valueIndex + 1, srcValLo, srcValHi);
        }
    }
}

