/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.geohash;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.PageFrameMemoryPool;

public class GeoHashNative {
    public static native long iota(long var0, long var2, long var4);

    public static void latestByAndFilterPrefix(PageFrameMemoryPool frameMemoryPool, long keysMemory, long keysMemorySize, long valuesMemory, long valuesMemorySize, long argsMemory, long unIndexedNullCount, long maxValue, long minValue, int frameIndex, int blockValueCountMod, int geoHashColumnIndex, int geoHashColumnType, long prefixesAddress, long prefixesCount) {
        int geoHashColumnSize;
        long geoHashColumnAddress = 0L;
        if (geoHashColumnIndex > -1) {
            PageFrameMemory frameMemory = frameMemoryPool.navigateTo(frameIndex);
            geoHashColumnAddress = frameMemory.getPageAddress(geoHashColumnIndex);
        }
        int n = geoHashColumnSize = ColumnType.isGeoHash(geoHashColumnType) ? GeoHashNative.getPow2SizeOfGeoHashType(geoHashColumnType) : -1;
        assert (geoHashColumnIndex == -1 || geoHashColumnSize != -1) : "no within filter or within on geohash column expected";
        GeoHashNative.latestByAndFilterPrefix(keysMemory, keysMemorySize, valuesMemory, valuesMemorySize, argsMemory, unIndexedNullCount, maxValue, minValue, 524287 - frameIndex, blockValueCountMod, geoHashColumnAddress, geoHashColumnSize, prefixesAddress, prefixesCount);
    }

    public static native long slideFoundBlocks(long var0, long var2);

    private static int getPow2SizeOfGeoHashType(int type) {
        return 1 << ColumnType.pow2SizeOfBits(ColumnType.getGeoHashBits(type));
    }

    private static native void latestByAndFilterPrefix(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, int var16, int var17, long var18, int var20, long var21, long var23);
}

