/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Interval;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class EqIntervalFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(\u0394\u0394)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function a = args.getQuick(0);
        Function b = args.getQuick(1);
        if (a.isConstant()) {
            return this.createHalfConstantFunc(a, b);
        }
        if (b.isConstant()) {
            return this.createHalfConstantFunc(b, a);
        }
        if (a.isRuntimeConstant()) {
            return new HalfRuntimeConstFunc(a, b);
        }
        if (b.isRuntimeConstant()) {
            return new HalfRuntimeConstFunc(b, a);
        }
        return new Func(a, b);
    }

    private Function createHalfConstantFunc(Function constFunc, Function varFunc) {
        Interval constValue = constFunc.getInterval(null);
        if (Interval.NULL.equals(constValue)) {
            return new NullCheckFunc(varFunc);
        }
        return new ConstCheckFunc(varFunc, constValue);
    }

    private static class HalfRuntimeConstFunc
    extends AbstractEqBinaryFunction {
        private Interval cachedRuntimeConst;

        public HalfRuntimeConstFunc(Function runtimeConst, Function arg) {
            super(arg, runtimeConst);
        }

        @Override
        public boolean getBool(Record rec) {
            Interval a = this.left.getInterval(rec);
            return this.negated != a.equals(this.cachedRuntimeConst);
        }

        @Override
        public String getName() {
            if (this.negated) {
                return "!=";
            }
            return "=";
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            this.cachedRuntimeConst = this.right.getInterval(null);
        }
    }

    private static class Func
    extends AbstractEqBinaryFunction {
        public Func(Function left, Function right) {
            super(left, right);
        }

        @Override
        public boolean getBool(Record rec) {
            Interval b;
            Interval a = this.left.getInterval(rec);
            return this.negated != a.equals(b = this.right.getInterval(rec));
        }

        @Override
        public String getName() {
            if (this.negated) {
                return "!=";
            }
            return "=";
        }
    }

    public static class NullCheckFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;

        public NullCheckFunc(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != Interval.NULL.equals(this.arg.getInterval(rec));
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val(" is not null");
            } else {
                sink.val(" is null");
            }
        }
    }

    private static class ConstCheckFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final Interval constant;

        public ConstCheckFunc(Function arg, @NotNull Interval constant) {
            this.arg = arg;
            this.constant = constant;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != this.constant.equals(this.arg.getInterval(rec));
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val('!');
            }
            sink.val("='").val(this.constant).val('\'');
        }
    }
}

