/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;

public class ShowServerVersionCursorFactory
extends AbstractRecordCursorFactory {
    public static final String SERVER_VERSION = "12.3 (questdb)";
    private static final GenericRecordMetadata METADATA = new GenericRecordMetadata();
    private static final int SIZE = 1;
    private final ShowServerVersionRecordCursor cursor = new ShowServerVersionRecordCursor();

    public ShowServerVersionCursorFactory() {
        super(METADATA);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("show_server_version");
    }

    static {
        METADATA.add(new TableColumnMetadata("server_version", 11));
    }

    private static class ShowServerVersionRecordCursor
    implements NoRandomAccessRecordCursor {
        private final Record record = new Record(){

            @Override
            public CharSequence getStrA(int col) {
                return col == 0 ? ShowServerVersionCursorFactory.SERVER_VERSION : null;
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStrA(col);
            }

            @Override
            public int getStrLen(int col) {
                return TableUtils.lengthOf(this.getStrA(col));
            }
        };
        private int idx = -1;

        private ShowServerVersionRecordCursor() {
        }

        @Override
        public void close() {
            this.idx = -1;
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            return ++this.idx < 1;
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public void toTop() {
            this.close();
        }
    }
}

