/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToTimestampFunction;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.std.IntList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class CastStrToTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Sn)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    public static class Func
    extends AbstractCastToTimestampFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public long getTimestamp(Record rec) {
            CharSequence value = this.arg.getStrA(rec);
            try {
                return value == null ? Long.MIN_VALUE : IntervalUtils.parseFloorPartialTimestamp(value);
            }
            catch (NumericException e) {
                return Long.MIN_VALUE;
            }
        }
    }
}

