/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class CastLong256ToStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Hs)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.get(0));
    }

    public static class Func
    extends StrFunction
    implements UnaryFunction {
        private final Function arg;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public Func(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            this.sinkA.clear();
            return SqlUtil.implicitCastLong256AsStr(this.arg.getLong256A(rec), this.sinkA) ? this.sinkA : null;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            this.sinkB.clear();
            return SqlUtil.implicitCastLong256AsStr(this.arg.getLong256A(rec), this.sinkB) ? this.sinkB : null;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg).val("::string");
        }
    }
}

