/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DirectArray;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class DoubleArrayShiftFunctionFactory
implements FunctionFactory {
    private static final String FUNCTION_NAME = "shift";

    @Override
    public String getSignature() {
        return "shift(D[]ID)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new Func(args.getQuick(0), args.getQuick(1), args.getQuick(2), configuration);
    }

    static void applyRecursive(ArrayView view, int dim, int flatIndex, int offset, MemoryA memory, double defaultValue) {
        boolean atDeepestDim;
        int count = view.getDimLen(dim);
        int stride = view.getStride(dim);
        boolean bl = atDeepestDim = dim == view.getDimCount() - 1;
        if (atDeepestDim) {
            if (offset > 0) {
                for (int i = 0; i < count; ++i) {
                    if (i >= offset) {
                        memory.putDouble(view.getDouble(flatIndex));
                        flatIndex += stride;
                        continue;
                    }
                    memory.putDouble(defaultValue);
                }
            } else {
                int absOffset = offset + count;
                flatIndex -= offset * stride;
                for (int i = 0; i < count; ++i) {
                    if (i < absOffset) {
                        memory.putDouble(view.getDouble(flatIndex));
                        flatIndex += stride;
                        continue;
                    }
                    memory.putDouble(defaultValue);
                }
            }
        } else {
            for (int i = 0; i < count; ++i) {
                DoubleArrayShiftFunctionFactory.applyRecursive(view, dim + 1, flatIndex, offset, memory, defaultValue);
                flatIndex += stride;
            }
        }
    }

    static void applyToEntireVanillaArray(ArrayView view, MemoryA memory, int offset, double defaultValue) {
        int lastDim = view.getDimLen(view.getDimCount() - 1);
        if (offset > 0) {
            int n = view.getFlatViewLength();
            for (int i = 0; i < n; ++i) {
                if (i % lastDim >= offset) {
                    memory.putDouble(view.getDouble(i - offset));
                    continue;
                }
                memory.putDouble(defaultValue);
            }
        } else {
            int absOffset = offset + lastDim;
            int n = view.getFlatViewLength();
            for (int i = 0; i < n; ++i) {
                if (i % lastDim < absOffset) {
                    memory.putDouble(view.getDouble(i - offset));
                    continue;
                }
                memory.putDouble(defaultValue);
            }
        }
    }

    private static class Func
    extends ArrayFunction
    implements TernaryFunction {
        private final DirectArray array;
        private final Function arrayArg;
        private final Function defaultValueFunction;
        private final Function shiftFunction;

        public Func(Function arrayArg, Function shiftFunction, Function defaultValueFunction, CairoConfiguration configuration) {
            this.arrayArg = arrayArg;
            this.shiftFunction = shiftFunction;
            this.defaultValueFunction = defaultValueFunction;
            this.type = arrayArg.getType();
            this.array = new DirectArray(configuration);
        }

        @Override
        public void close() {
            TernaryFunction.super.close();
            Misc.free(this.array);
        }

        @Override
        public ArrayView getArray(Record rec) {
            ArrayView arr = this.arrayArg.getArray(rec);
            if (arr.isNull()) {
                this.array.ofNull();
                return this.array;
            }
            int offset = this.shiftFunction.getInt(rec);
            if (offset == 0) {
                return arr;
            }
            MemoryA memory = this.array.copyShapeAndStartMemoryA(arr);
            double defaultValue = this.defaultValueFunction.getDouble(rec);
            if (arr.isVanilla()) {
                DoubleArrayShiftFunctionFactory.applyToEntireVanillaArray(arr, memory, offset, defaultValue);
            } else {
                DoubleArrayShiftFunctionFactory.applyRecursive(arr, 0, 0, offset, memory, defaultValue);
            }
            return this.array;
        }

        @Override
        public Function getCenter() {
            return this.shiftFunction;
        }

        @Override
        public Function getLeft() {
            return this.arrayArg;
        }

        @Override
        public String getName() {
            return DoubleArrayShiftFunctionFactory.FUNCTION_NAME;
        }

        @Override
        public Function getRight() {
            return this.defaultValueFunction;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }
    }
}

