/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class DoubleArrayInsertionPointAfterEqualFunctionFactory
implements FunctionFactory {
    private static final String FUNCTION_NAME = "insertion_point";

    @Override
    public String getSignature() {
        return "insertion_point(D[]D)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function arrayArg = args.getQuick(0);
        if (ColumnType.decodeArrayDimensionality(arrayArg.getType()) != 1) {
            throw SqlException.position(argPositions.getQuick(0)).put("array is not one-dimensional");
        }
        return new Func(arrayArg, args.get(1));
    }

    static class Func
    extends IntFunction
    implements BinaryFunction {
        private final Function arrayArg;
        private final Function valueArg;

        Func(Function arrayArg, Function valueArg) {
            this.arrayArg = arrayArg;
            this.valueArg = valueArg;
        }

        @Override
        public int getInt(Record rec) {
            ArrayView arr = this.arrayArg.getArray(rec);
            if (arr.isNull()) {
                return Integer.MIN_VALUE;
            }
            int index = arr.binarySearchDoubleValue1DArray(this.valueArg.getDouble(rec), false);
            return index < 0 ? -index : index + 2;
        }

        @Override
        public Function getLeft() {
            return this.arrayArg;
        }

        @Override
        public String getName() {
            return DoubleArrayInsertionPointAfterEqualFunctionFactory.FUNCTION_NAME;
        }

        @Override
        public Function getRight() {
            return this.valueArg;
        }
    }
}

