/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.griffin.QueryFutureUpdateListener;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.griffin.engine.window.WindowContext;
import io.questdb.griffin.model.IntrinsicModel;
import io.questdb.std.Rnd;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Path;
import io.questdb.std.str.Sinkable;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SqlExecutionContext
extends Sinkable,
Closeable {
    public boolean allowNonDeterministicFunctions();

    public void clearWindowContext();

    @Override
    default public void close() {
    }

    public void configureWindowContext(@Nullable VirtualRecord var1, @Nullable RecordSink var2, @Nullable ColumnTypes var3, boolean var4, int var5, int var6, boolean var7, int var8, long var9, int var11, long var12, int var14, int var15, int var16, int var17, boolean var18, int var19);

    default public void containsSecret(boolean b) {
    }

    default public boolean containsSecret() {
        return false;
    }

    default public Rnd getAsyncRandom() {
        return SharedRandom.getAsyncRandom(this.getCairoEngine().getConfiguration());
    }

    public BindVariableService getBindVariableService();

    @NotNull
    public CairoEngine getCairoEngine();

    @NotNull
    public SqlExecutionCircuitBreaker getCircuitBreaker();

    public boolean getCloneSymbolTables();

    public int getJitMode();

    @NotNull
    default public MessageBus getMessageBus() {
        return this.getCairoEngine().getMessageBus();
    }

    default public TableRecordMetadata getMetadataForWrite(TableToken tableToken, long desiredVersion) {
        return this.getCairoEngine().getLegacyMetadata(tableToken, desiredVersion);
    }

    default public TableRecordMetadata getMetadataForWrite(TableToken tableToken) {
        return this.getMetadataForWrite(tableToken, -1L);
    }

    public long getMicrosecondTimestamp();

    public long getNow();

    public QueryFutureUpdateListener getQueryFutureUpdateListener();

    public Rnd getRandom();

    default public TableReader getReader(TableToken tableName, long version) {
        return this.getCairoEngine().getReader(tableName, version);
    }

    default public TableReader getReader(TableToken tableName) {
        return this.getCairoEngine().getReader(tableName);
    }

    public long getRequestFd();

    @NotNull
    public SecurityContext getSecurityContext();

    public int getSharedQueryWorkerCount();

    public SqlExecutionCircuitBreaker getSimpleCircuitBreaker();

    default public int getTableStatus(Path path, CharSequence tableName) {
        return this.getCairoEngine().getTableStatus(path, tableName);
    }

    default public int getTableStatus(Path path, TableToken tableToken) {
        return this.getCairoEngine().getTableStatus(path, tableToken);
    }

    default public TableToken getTableToken(CharSequence tableName) {
        return this.getCairoEngine().verifyTableName(tableName);
    }

    default public TableToken getTableToken(CharSequence tableName, int lo, int hi) {
        return this.getCairoEngine().verifyTableName(tableName, lo, hi);
    }

    default public TableToken getTableTokenIfExists(CharSequence tableName) {
        return this.getCairoEngine().getTableTokenIfExists(tableName);
    }

    default public TableToken getTableTokenIfExists(CharSequence tableName, int lo, int hi) {
        return this.getCairoEngine().getTableTokenIfExists(tableName, lo, hi);
    }

    public WindowContext getWindowContext();

    public void initNow();

    public boolean isCacheHit();

    public boolean isColumnPreTouchEnabled();

    public boolean isColumnPreTouchEnabledOverride();

    default public boolean isOverriddenIntrinsics(TableToken tableToken) {
        return false;
    }

    public boolean isParallelFilterEnabled();

    public boolean isParallelGroupByEnabled();

    public boolean isParallelReadParquetEnabled();

    public boolean isParallelTopKEnabled();

    public boolean isTimestampRequired();

    default public boolean isUninterruptible() {
        return false;
    }

    public boolean isWalApplication();

    default public void overrideWhereIntrinsics(TableToken tableToken, IntrinsicModel intrinsicModel) {
    }

    public void popTimestampRequiredFlag();

    public void pushTimestampRequiredFlag(boolean var1);

    public void resetFlags();

    public void setAllowNonDeterministicFunction(boolean var1);

    public void setCacheHit(boolean var1);

    public void setCancelledFlag(AtomicBoolean var1);

    public void setCloneSymbolTables(boolean var1);

    public void setColumnPreTouchEnabled(boolean var1);

    public void setColumnPreTouchEnabledOverride(boolean var1);

    public void setJitMode(int var1);

    public void setNowAndFixClock(long var1);

    public void setParallelFilterEnabled(boolean var1);

    public void setParallelGroupByEnabled(boolean var1);

    public void setParallelReadParquetEnabled(boolean var1);

    public void setParallelTopKEnabled(boolean var1);

    public void setRandom(Rnd var1);

    public void setUseSimpleCircuitBreaker(boolean var1);

    default public boolean shouldLogSql() {
        return true;
    }

    default public void storeTelemetry(short event, short origin) {
    }

    @Override
    default public void toSink(@NotNull CharSink<?> sink) {
    }
}

